% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.loca.p.matrix}
\alias{as.loca.p.matrix}
\title{as.loca.p.matrix
S3 method to convert from matrix to loca.p}
\usage{
as.loca.p.matrix(x, ...)
}
\arguments{
\item{x}{is the object to convert to the new class object.}

\item{...}{Other arguments, unused.}
}
\value{
If the arguments have valid values, it returns a new object of the new class.
}
\description{
Conversions between loca.p class and some others classes
}
\details{
Methods to convert from and to \code{loca.p} class.


NA's  values are not allowed in any of the arguments.

The \code{matrix} to convert into \code{loca.p} must have at least two columns.
The first column will be consider as the x coordinates, the second as the y coordinates, and the third (if given) as the values of w.

The \code{data.frame} to convert into \code{loca.p} must have at least an \code{x} column for x coordinates, and an \code{y} column for y coordinates. Optionally, it can have \code{w} column, as the values of w.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))

# Conversion to matrix
m <- as.matrix(loca)

# Show matrix
m

# Conversion from matrix
as.loca.p(m)
}
\seealso{
See also \code{\link{loca.p}}
}
