% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordr.r
\docType{package}
\name{ordr}
\alias{ordr}
\alias{ordr-package}
\title{\strong{ordr} package}
\description{
This is a \strong{\href{https://www.tidyverse.org/}{tidyverse}} extension
for handling, manipulating, and visualizing ordination models with
consistent conventions and in a tidy workflow.
}
\details{
This package is designed to integrate ordination analysis and biplot
visualization into a \strong{tidyverse} workflow. It is inspired in particular by
the extensions \strong{ggbiplot} and \strong{tidygraph}.

The package consists in several modules:
\itemize{
\item the '\link{tbl_ord}' class, a wrapper for various ordination object classes
\item extracting \link{augmentation} for the factors of an ordination
\item using \link{dplyr-verbs} to add \link{annotation} to the factors
\item adjusting the \link{conference} of inertia between the factors
\item methods of the above generics for several widely-used object classes
\item convenient \link[=format]{formatting} of ordination objects
\item \code{\link[=ggbiplot]{ggbiplot()}}, a \strong{ggplot2} extension for rendering biplots
\item additional \link[=biplot-stats]{stats} and \link[=biplot-geoms]{geoms} for biplots
}
}
\section{Ordinations and biplots}{

\emph{Ordination} encompasses a variety of techniques for data compression,
dimension reduction, feature extraction, and visualization. Well-known
ordination techniques are predominantly unsupervised and include principal
components analysis, multidimensional scaling, and correspondence analyis
(Podani, 2000, Chapter 7; Palmer, n.d.). These methods are theoretically
grounded in geometric data analysis (Le Roux & Rouanet, 2004) and powered by
the matrix factorizations described below. A variety of other techniques may
also be viewed, or treated using the same tools, as ordination, including
linear regression, linear discriminant analysis, k-means clustering, and
non-negative matrix factorization.

\emph{Biplots} are two-layered scatterplots widely used to visualize unsupervised
SVD-based ordinations. Gabriel (1971) introduced biplots to represent the
scores and loadings of PCA on a single set of axes. They have also been used
to visualize generalized linear regression and linear discriminant analysis
(Greenacre, 2010) and can adapted to any 2-factor matrix decomposition.
}

\section{Singular value decomposition}{

The most popular ordination techniques use singular value decomposition (SVD)
to factor a data matrix \eqn{X} into a product \eqn{X=UDV'} of two orthogonal
(rotation) matrices \eqn{U} and \eqn{V} and a diagonal (scaling) matrix
\eqn{D}, with \eqn{V'} the transpose of \eqn{V}. In most cases, the data
matrix \eqn{X} is transformed from an original data matrix, e.g. by
centering, scaling, double-centering, or log-transforming. The SVD introduces
a set of shared orthogonal coordinates in which \eqn{U} encodes the rows of
\eqn{X} and \eqn{V} encodes the columns of \eqn{X}. The singular values in
\eqn{D} are the variances of \eqn{X} along each of these coordinates, and
they proceed in decreasing order, so that the first \eqn{r} (for "rank")
columns of \eqn{U} and of \eqn{V} produce a geometrically optimized
approximation to \eqn{X}.

Biplots of SVD-based ordinations usually plot the rows and columns of \eqn{X}
on these \eqn{r} coordinate axes. For an SVD-based biplot to be truly
geometric, the total variance contained in \eqn{D} must be conferred onto
\eqn{U} or \eqn{V}, or distributed over both (Orlov, 2015). When \eqn{D} is
conferred onto \eqn{U}, the rows of \eqn{X} are represented by the rows of
\eqn{UD}, and their distances in the biplot approximate their distances in
the original column space of \eqn{X}. Meanwhile, the columns of \eqn{X} are
represented by the rows of \eqn{V}. These are unit vectors in the full space
of shared coordinates, so their squared lengths in the biplot indicate the
proportion of their variance captured by the biplot axes and their cosines
with each other approximate the correlations between the columns. Finally,
the projection of a row's coordinates (point) onto a column's coordinates
(vector) approximates the corresponding entry of \eqn{X}.
}

\references{
Podani J (2000) "Ordination". \emph{Introduction to the Exploration of
Multivariate Biological Data} Chapter 7, 215--284. Backhuys Publishers, ISBN
90-5782-067-6.
\url{https://web.archive.org/web/20200221000313/http://ramet.elte.hu/~podani/books.html}

Palmer M \emph{Ordination Methods for Ecologists}. Website, accessed 2019-07-12.
\url{http://ordination.okstate.edu/}

Le Roux B & Rouanet H (2004) \emph{Geometric Data Analysis: From Correspondence
Analysis to Stsructured Data Analysis}. Springer Dordrecht, ISBN:
978-1-4020-2236-4. \doi{10.1007/1-4020-2236-0}
\url{https://link.springer.com/book/10.1007/1-4020-2236-0}

Gabriel KR (1971) "The biplot graphic display of matrices with application to
principal component analysis". \emph{Biometrika} 58(3), 453--467.
\doi{10.1093/biomet/58.3.453}

Greenacre MJ (2010) \emph{Biplots in Practice}. Fundacion BBVA, ISBN:
978-84-923846.
\url{https://www.fbbva.es/microsite/multivariate-statistics/biplots.html}

Orlov K (2015) \emph{Answer to} "PCA and Correspondence analysis in their relation
to Biplot". CrossValidated, accessed 2019-07-12.
\url{https://stats.stackexchange.com/a/141755/68743}
}
