% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ordinalbayes}
\alias{predict.ordinalbayes}
\alias{fitted.ordinalbayes}
\title{Predicted Probabilities and Class for an Ordinal Bayes Fit.}
\usage{
\method{predict}{ordinalbayes}(
  object,
  neww = NULL,
  newdata,
  newx = NULL,
  model.select = "average",
  ...
)
}
\arguments{
\item{object}{an \code{ordinalBayes} fitted object.}

\item{neww}{an optional formula that includes the unpenalized variables to use for predicting the response. If omitted, the training data are used.}

\item{newdata}{an optional data.frame that minimally includes the unpenalized variables to use for predicting the response. If omitted, the training data are used.}

\item{newx}{an optional matrix of penalized variables to use for predicting the response. If omitted, the training data are used.}

\item{model.select}{when \code{"average"} (default) is used, the mean coefficient values over the MCMC chain are used to estimate fitted probabilities; when  \code{"median"} is used, the median coefficient values over the MCMC chain are used to estimate fitted probabilities;  when \code{"max.predicted.class"} is used, each step in the chain is used to calculate fitted probabilities and the class. The predicted class is that attaining the maximum fitted probability.}

\item{...}{other arguments.}
}
\value{
\item{predicted}{a matrix of predicted probabilities from the fitted model.}

\item{class}{a vector containing the predicted class taken as that class having the largest predicted probability.}
}
\description{
Predicted Probabilities and Class for an Ordinal Bayes Fit.
}
\examples{
\donttest{
data("cesc")
fit<-ordinalbayes(Stage~1, data=cesc, x=cesc[,5:45],,
     model="regressvi", gamma.ind="fixed", pi.fixed=0.99,
     adaptSteps=1000, burnInSteps=1000, nChains=2, numSavedSteps=2000,
     thinSteps=2, seed=26)
phat<-predict(fit)
table(phat$class, cesc$Stage)
}
}
\seealso{
\code{\link{ordinalbayes}}, \code{\link{coef.ordinalbayes}}, \code{\link{summary.ordinalbayes}}, \code{\link{print.ordinalbayes}}
}
