% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_weibullg.R
\name{order_weibullg}
\alias{order_weibullg}
\title{Random Sampling of Order Statistics from a Weibull G Distribution}
\usage{
order_weibullg(size, spec, beta, c, k, n, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{spec}{character, represents an specific G distribution. Possible values "norm", "exp","lnorm","chisq".}

\item{beta}{numeric, represents the scale parameter. Default value is 1.}

\item{c}{numeric, represents the shape parameter. Default value is 1.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{...}{represents others parameters of the G distribution.}
}
\value{
A list with a random sample of order statistics from a Weibull G Distribution and the value of its join probability density function evaluated in the random sample.
}
\description{
\code{order_weibullg} is used to obtain a random sample of order statistics from a Weibull G Distribution.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from a Weibull Exponential Distribution
order_weibullg(10,"exp",beta=1,c=1,k=3,n=50)
# A sample of size 10 of the 3-th order statistics from a Weibull Normal Distribution
order_weibullg(10,"norm",beta=1,c=1,k=3,n=50)
# A sample of size 10 of the 3-th order statistics from a Weibull Log-normal Distribution
order_weibullg(10,"lnorm",beta=1,c=1,k=3,n=50)
# A sample of size 10 of the 3-th order statistics from a Weibull Chi-square Distribution
order_weibullg(10,"chisq",beta=1,c=1,k=3,n=50,df=3)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statistical Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
