% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optint.R
\name{optint_by_group}
\alias{optint_by_group}
\title{Optimal intervention, by group}
\usage{
optint_by_group(Y, X, group, control = NULL, wgt = rep(1, length(Y)),
  method = "non-parametric", lambda = 100, sigma = 1,
  grp.size = 30, n.boot = 1000, alpha = 0.05, plot = TRUE)
}
\arguments{
\item{Y}{outcome vector (must be numeric without NA's).}

\item{X}{numeric data frame or matrix of factors to be considered.}

\item{group}{vector with group labels (i.e. grouping variable). the function
\code{\link{optint}} implemented for each group separately.}

\item{control}{numeric data frame or matrix of factors to control for. these are factors
that we can't consider while looking for the optimal intervention
(e.g. race).}

\item{wgt}{an optional vector of weights.}

\item{method}{the method to be used. either "non-parametric" (default), "correlation" or
"nearest-neighbors".}

\item{lambda}{the lagrange multiplier. also known as the shadow price of an
intervention.}

\item{sigma}{distance penalty for the nearest-neighbors method.}

\item{grp.size}{for the nearest-neighbors method; if the number of examples in each
control group is smaller than grp.size, performs weight adjustment
using \code{\link[optinterv]{wgt_adjust}}. else,
calculate weights seperatly for each control group.}

\item{n.boot}{number of bootstrap replications to use for the standard errors /
confidence intervals calculation.}

\item{alpha}{significance level for the confidence intervals.}

\item{plot}{logical. if TRUE (default), the results are plotted by
\code{\link{plot.optint_by_group}}.}
}
\value{
an object of class "optint_by_group". This object is a list containing
        two components:
 \item{est}{a matrix of estimates (in their original units), for each group.
            here estimates are \eqn{E(X | I=1) - E(X | I=0)}, and they are
            used by \code{\link{plot.optint_by_group}}.}
 \item{sd}{estimates standard deviation.}
}
\description{
Similar to \code{\link{optint}}, identifies the factors with the greatest
potential to increase a pre-specified outcome for each group separately, and thus allowing
to detect heterogeneity between groups.
}
\examples{
# generate data
n <- 50
p <- 3
features <- matrix(rnorm(n*p), ncol = p)
men <- matrix(rbinom(n, 1, 0.5), nrow = n)
outcome <- 2*(features[,1] > 1) + men*pmax(features[,2], 0) + rnorm(n)
outcome <- as.vector(outcome)

#find the optimal intervention using the non-parametric method:
imp_feat <- optint(Y = outcome, X = features, control = men,
                   method = "non-parametric", lambda = 10, plot = TRUE,
                   n.boot = 100, n.perm = 100)

#we can explore how the optimal intervention varies between genders using optint_by_group():
men <- as.vector(men)
imp_feat_by_gender <- optint_by_group(Y = outcome, X = features,
                                      group = men,
                                      method = "non-parametric",
                                      lambda = 10)

#by default, only the significant features are displayed
#(see ?plot.optint_by_group for further details).
#for customized variable importance plot, use plot():
plot(imp_feat_by_gender, plot.vars = 3)

}
