% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs.R
\name{ggpairs}
\alias{ggpairs}
\title{Plot multiple axes of a data frame or a fortified dimension reduction.}
\usage{
ggpairs(df_data, group = NULL, axes = 1:2, variables = FALSE,
  n_vars = 0, ellipses = FALSE, ..., title = NULL, colors = if
  (!is.null(group)) nice_palette(df_data[[group]]))
}
\arguments{
\item{df_data}{Data frame}

\item{group}{Column name of the grouping of observations}

\item{axes}{Axes to plot. If more than 2, plots all pair combinations}

\item{variables}{Logical, plot variable contributions of the dimension
reduction to the selected axes, only for 2 axes}

\item{n_vars}{Maximum number of variable contributions to plot. By
default 0, for all variables.}

\item{ellipses}{Logical, plot ellipses of groups}

\item{...}{Passed to ggplot2 stat_ellipse if ellipses are requested}

\item{title}{String to add as title, default NULL}

\item{colors}{Vector of colors for each group}
}
\value{
ggmatrix
}
\description{
Plot multiple axes of a data frame or a fortified dimension reduction.
}
\examples{
df_pca <- fortify_pca(iris[-5])
ggpairs(df_pca)
df_pca <- fortify_pca(iris[-5], sup_vars = iris[5])
ggpairs(df_pca, group = 'Species', ellipses = TRUE, variables = TRUE)
}
\seealso{
\link{fortify_pca}, \link{fortify_ica}
}
