\name{noffspring}
\Rdversion{1.1}
\alias{noffspring}
\title{Calculates Optimum Numbers of Offspring}

\description{
Calculates the optimum numbers of offspring from optimum contributions of selection candidates.
}
\usage{
noffspring(cand, N)}

\arguments{
\item{cand}{Data frame with optimum contributions (column \code{oc}), sexes (column \code{Sex}), and IDs (column \code{Indiv}) of the selection candidates.}
\item{N}{Desired number of individuals in the offspring population.}
}

\details{
The function calculates the optimum numbers of offspring of the selection candidates from the optimum contributions \code{cand$oc} and the size \code{N} of the offspring population.
}

\value{

Data frame with column \code{Indiv} containing the individual IDs and column \code{nOff} containing the optimum numbers of offspring. 

Column \code{nOff} is approximately \code{2*N*cand$oc} with \code{sum(noff[cand$Sex=="male"])=N} and \code{sum(noff[cand$Sex=="female"])=N}.
}


\examples{
data(PedigWithErrors)
data(Phen)

keep  <- Phen$Indiv
Pedig <- prePed(PedigWithErrors, keep=keep, thisBreed="Hinterwaelder", lastNative=1970)
cand   <- candes(phen=Phen, fA=pedIBD(Pedig, keep.only=keep))
con   <- list(ub.fA=0.03, uniform="female")
Offspring <- opticont("max.BV", cand, con, trace = FALSE)


N <- 150
Candidate <- Offspring$parent
Candidate$nOff <- noffspring(Candidate, N)$nOff

sum(Candidate$nOff[Candidate$Sex=="male"])
#[1] 150

sum(Candidate$nOff[Candidate$Sex=="female"])
#[1] 150

round(2*N*Candidate$oc-Candidate$nOff, 2)
}

\author{Robin Wellmann}
