% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_eff.R
\name{crit}
\alias{crit}
\title{Master function for the criterion function}
\usage{
crit(Criterion, M, k = 0, par_int = c(1), matB = NA)
}
\arguments{
\item{Criterion}{Character with the chosen optimality criterion. Can be one of the following:
\itemize{
\item 'D-Optimality'
\item 'Ds-Optimality'
\item 'A-Optimality'
\item 'I-Optimality'
}}

\item{M}{Information matrix for which the criterion value wants to be calculated.}

\item{k}{Numeric number of parameters of the model. Taken from the number of rows of the matrix if omitted.}

\item{par_int}{Numeric vector with the index of the parameters of interest of the model. Only for "Ds-Optimality".}

\item{matB}{Matrix of the integral of the information matrix over the interest region. Only for "I-Optimality".}
}
\value{
Numeric value of the optimality criterion for the information matrix.
}
\description{
Depending on the Criterion input, the function returns the output of the corresponding criterion function given
the information matrix.
}
