% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{deleteData}
\alias{deleteData}
\title{Delete cell data}
\usage{
deleteData(wb, sheet, cols, rows, gridExpand = FALSE)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{columns to delete data from.}

\item{rows}{Rows to delete data from.}

\item{gridExpand}{If \code{TRUE}, all data in rectangle min(rows):max(rows) X min(cols):max(cols)
will be removed.}
}
\description{
Delete contents and styling from a cell.
}
\examples{
## write some data
wb <- createWorkbook()
addWorksheet(wb, "Worksheet 1")
x <- data.frame(matrix(runif(200), ncol = 10)) 
writeData(wb, sheet = 1, x = x, startCol = 2, startRow = 3, colNames = FALSE)

## delete some data
deleteData(wb, sheet = 1, cols = 3:5, rows = 5:7, gridExpand = TRUE)
deleteData(wb, sheet = 1, cols = 7:9, rows = 5:7, gridExpand = TRUE)
deleteData(wb, sheet = 1, cols = LETTERS, rows = 18, gridExpand = TRUE)

saveWorkbook(wb, "deleteDataExample.xlsx", overwrite = TRUE)
}
\author{
Alexander Walker
}

