% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-routing-options.R
\name{otp_routing_options}
\alias{otp_routing_options}
\title{Make routingOptions object}
\usage{
otp_routing_options()
}
\description{
OTP supports a wide selection of routing options `otp_plan()` accepts a
named list of these options. This function produces an empty named list
of valid options supported by both this package and OTP.
}
\details{
Supports almost all of the possible options in OTP 1.4. Note that some
of the most popular option (mode, date, time, etc.) are set directly
in `otp_plan()`. If you want to permenaty set an option many are supported
in the config files, see help on `otp_make_config()`.

http://dev.opentripplanner.org/apidoc/1.4.0/resource_PlannerResource.html
}
\examples{
\dontrun{
routingOptions <- otp_routing_options()
routingOptions$walkSpeed <- 1.5
routingOptions <- otp_validate_routing_options(routingOptions)
}
}
\seealso{
Other routing: 
\code{\link{otp_geocode}()},
\code{\link{otp_isochrone}()},
\code{\link{otp_plan}()},
\code{\link{otp_pointset}()},
\code{\link{otp_validate_routing_options}()}
}
\concept{routing}
