% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffie.R
\name{ec_dh}
\alias{ec_dh}
\title{Diffie-Hellman Key Agreement}
\usage{
ec_dh(key = my_key(), peerkey, password = askpass)
}
\arguments{
\item{key}{your own private key}

\item{peerkey}{the public key from your peer}

\item{password}{passed to \link{read_key} for reading protected private keys}
}
\description{
Key agreement is one-step method of creating a shared secret between two
peers. Both peers can indendently derive the joined secret by combining
his or her private key with the public key from the peer.
}
\details{
Currently only Elliptic Curve Diffie Hellman (ECDH) is implemented.
}
\examples{
\dontrun{
# Need two EC keypairs from the same curve
sk1 <- ec_keygen()
pk1 <- as.list(sk1)$pubkey

sk2 <- ec_keygen()
pk2 <- as.list(sk2)$pubkey

# Both peers can derive the shared secret
alice <- ec_dh(sk1, pk2)
bob <- ec_dh(sk2, pk1)
}
}
\references{
\url{https://wiki.openssl.org/index.php/EVP_Key_Agreement},
\url{https://wiki.openssl.org/index.php/Elliptic_Curve_Diffie_Hellman}
}

