% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openmeteo.R
\docType{package}
\name{openmeteo}
\alias{openmeteo}
\title{openmeteo: retrieve weather data from the Open-Meteo API}
\description{
\code{openmeteo} provides functions for accessing the Open-Meteo
weather API, enabling the desired weather data or forecasts to be retrieved
in a tidy data format. An API key is \emph{not} required to access the
Open-Meteo API.

Open-Meteo provides several API endpoints. This package
currently enables access to the \emph{Weather Forecast API}, the \emph{Historical
Weather API}, and the \emph{Geocoding API} through the following functions:
\itemize{
\item \code{\link[=weather_forecast]{weather_forecast()}} - retrieve weather forecasts for a location
\item \code{\link[=weather_history]{weather_history()}} - retrieve historical weather observations for a
location
\item \code{\link[=weather_now]{weather_now()}} - simple function to return current weather for a
location
\item \code{\link[=geocode]{geocode()}} - return the co-ordinates and other data for a location name
\item \code{\link[=weather_variables]{weather_variables()}} - retrieve a shortlist of valid forecast or
historical weather variables provided
}

Please review the API documentation at \url{https://open-meteo.com/} for
details regarding the data available, its types, units, and other caveats
and considerations.
}
