% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_odf.R
\name{read_odf}
\alias{read_odf}
\title{Read data specified as Open Data Format.}
\usage{
read_odf(
  file,
  languages = "all",
  nrows = Inf,
  skip = 0,
  select = NULL,
  na.strings = getOption("datatable.na.strings", "NA")
)
}
\arguments{
\item{file}{the name of the file which the data are to be read from.
By default all available language variants are imported
(\code{languages = "all"}).}

\item{languages}{integer: the maximum number of rows to read in. Negative and other invalid
values are ignored.}

\item{nrows}{Maximum number of lines to read.}

\item{skip}{Select the number of rows to be skipped (without the column names).}

\item{select}{A vector of column names or numbers to keep, drop the rest. In all forms of
select, order that the columns are specified determines the order of the
columns in the result.}

\item{na.strings}{A character vector of strings which are to be interpreted as NA values. By
default, ",," for columns of all types, including type character is read as
NA for consistency. ,"", is unambiguous and read as an empty string. To
read ,NA, as NA, set na.strings="NA". To read ,, as blank string "", set
na.strings=NULL. When they occur in the file, the strings in na.strings
should not appear quoted since that is how the string literal ,"NA", is
distinguished from NA, for example, when na.strings="NA".}
}
\value{
R dataframe with attributes including dataset and variable
information.
}
\description{
Import data from the Open Data Format to an R data frame.
}
\examples{
# get path to example data from the opendataformat package (data.zip)
path  <-  system.file("extdata", "data.odf.zip", package = "opendataformat")
path

# read example data specified as Open Data Format from ZIP file
df  <-  read_odf(file = path)
attributes(df)
attributes(df$bap87)

# read example data with language selection
df  <-  read_odf(file = path, languages = "de")
attributes(df$bap87)

}
