% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/images.R
\name{images}
\alias{images}
\title{images Class}
\description{
images Class

images Class
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{images}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-images-create}{\code{images$create()}}
\item \href{#method-images-edit}{\code{images$edit()}}
\item \href{#method-images-variation}{\code{images$variation()}}
\item \href{#method-images-clone}{\code{images$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-images-create"></a>}}
\if{latex}{\out{\hypertarget{method-images-create}{}}}
\subsection{Method \code{create()}}{
Creates an image given a prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{images$create(prompt, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{character Required. A text description of the desired image(s).
The maximum length is 1000 characters for dall-e-2 and 4000 characters for dall-e-3}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:n;quality;response_format...}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list of image objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-images-edit"></a>}}
\if{latex}{\out{\hypertarget{method-images-edit}{}}}
\subsection{Method \code{edit()}}{
Creates an edited or extended image given an original image and a prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{images$edit(image, prompt, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{character Required. The image to edit. Must be a valid PNG file, less than 4MB,
and square. If mask is not provided, image must have transparency, which will be used as the mask.}

\item{\code{prompt}}{character Required. A text description of the desired image(s). The maximum length is 1000 characters.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:mask;model;n...}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list of image objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-images-variation"></a>}}
\if{latex}{\out{\hypertarget{method-images-variation}{}}}
\subsection{Method \code{variation()}}{
Creates a variation of a given image.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{images$variation(image, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{character Required. The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:model;n;response_format}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list of image objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-images-clone"></a>}}
\if{latex}{\out{\hypertarget{method-images-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{images$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
