/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.tools.ngram.Token;

public final class TokenSet {
    private static Logger sLogger = Logger.getLogger(TokenSet.class.getName());
    private static TokenSet sInstance;
    private Map mTokenTable = new WeakHashMap();

    private TokenSet() {
        if (sLogger.isLoggable(Level.FINEST)) {
            Thread statisticLogger = new Thread((Runnable)new StatisticLogger(), "TokenSet Statistics Logger");
            statisticLogger.setDaemon(true);
            statisticLogger.start();
        }
    }

    synchronized Token insert(Token token) {
        WeakReference weakCachedToken = (WeakReference)this.mTokenTable.get(token.getToken());
        Token cachedToken = weakCachedToken != null ? weakCachedToken.get() : null;
        if (cachedToken != null) {
            return cachedToken;
        }
        this.mTokenTable.put(token.getToken(), new WeakReference<Token>(token));
        return token;
    }

    public static synchronized TokenSet getInstance() {
        if (sInstance == null) {
            sInstance = new TokenSet();
        }
        return sInstance;
    }

    private final class StatisticLogger
    implements Runnable {
        private static final int INTERVAL = 5000;

        private StatisticLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int lastSize = -1;
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                TokenSet tokenSet = TokenSet.this;
                synchronized (tokenSet) {
                    int currentSize = TokenSet.this.mTokenTable.size();
                    if (lastSize != currentSize) {
                        sLogger.finest("Size: " + currentSize);
                        lastSize = currentSize;
                    }
                }
            }
        }
    }
}

