/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.namefind.AdaptiveFeatureGenerator;

public class WindowFeatureGenerator
implements AdaptiveFeatureGenerator {
    public static final String PREV_PREFIX = "p";
    public static final String NEXT_PREFIX = "n";
    private final AdaptiveFeatureGenerator generator;
    private final int prevWindowSize;
    private final int nextWindowSize;

    public WindowFeatureGenerator(AdaptiveFeatureGenerator generator, int prevWindowSize, int nextWindowSize) {
        this.generator = generator;
        this.prevWindowSize = prevWindowSize;
        this.nextWindowSize = nextWindowSize;
    }

    public WindowFeatureGenerator(AdaptiveFeatureGenerator generator) {
        this(generator, 5, 5);
    }

    public void createFeatures(List features, String[] tokens, int index, String[] preds) {
        Iterator it;
        int i;
        this.generator.createFeatures(features, tokens, index, preds);
        for (i = 1; i < this.prevWindowSize + 1; ++i) {
            if (index - i < 0) continue;
            ArrayList prevFeatures = new ArrayList();
            this.generator.createFeatures(prevFeatures, tokens, index - i, preds);
            it = prevFeatures.iterator();
            while (it.hasNext()) {
                features.add(PREV_PREFIX + i + it.next().toString());
            }
        }
        for (i = 1; i < this.nextWindowSize + 1; ++i) {
            if (i + index >= tokens.length) continue;
            ArrayList nextFeatures = new ArrayList();
            this.generator.createFeatures(nextFeatures, tokens, index + i, preds);
            it = nextFeatures.iterator();
            while (it.hasNext()) {
                features.add(NEXT_PREFIX + i + it.next().toString());
            }
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        this.generator.updateAdaptiveData(tokens, outcomes);
    }

    public void clearAdaptiveData() {
        this.generator.clearAdaptiveData();
    }

    public String toString() {
        return super.toString() + ": Prev windwow size: " + this.prevWindowSize + ", Next window size: " + this.nextWindowSize;
    }
}

