/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.DiscourseModel;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.resolver.Resolver;
import opennlp.tools.util.CountedSet;

public abstract class AbstractResolver
implements Resolver {
    protected int numEntitiesBack;
    protected boolean showExclusions;
    protected CountedSet distances;
    protected int numSentencesBack;

    public AbstractResolver(int neb) {
        this.numEntitiesBack = neb;
        this.showExclusions = true;
        this.distances = new CountedSet();
    }

    protected int getNumEntities() {
        return this.numEntitiesBack;
    }

    public void setNumberSentencesBack(int nsb) {
        this.numSentencesBack = nsb;
    }

    protected int getNumEntities(DiscourseModel dm) {
        return Math.min(dm.getNumEntities(), this.numEntitiesBack);
    }

    protected Parse getHead(MentionContext mention) {
        return mention.getHeadTokenParse();
    }

    protected int getHeadIndex(MentionContext mention) {
        Parse[] mtokens = mention.getTokenParses();
        for (int ti = mtokens.length - 1; ti >= 0; --ti) {
            Parse tok = mtokens[ti];
            if (tok.getSyntacticType().equals("POS") || tok.getSyntacticType().equals(",") || tok.getSyntacticType().equals(".")) continue;
            return ti;
        }
        return mtokens.length - 1;
    }

    protected String getHeadString(MentionContext mention) {
        return mention.getHeadTokenText().toLowerCase();
    }

    protected boolean outOfRange(MentionContext mention, DiscourseEntity entity) {
        return false;
    }

    protected boolean excluded(MentionContext mention, DiscourseEntity entity) {
        MentionContext cec = entity.getLastExtent();
        return mention.getSentenceNumber() == cec.getSentenceNumber() && mention.getIndexSpan().getEnd() <= cec.getIndexSpan().getEnd();
    }

    public DiscourseEntity retain(MentionContext mention, DiscourseModel dm) {
        if (mention.getId() == -1) {
            return null;
        }
        for (int ei = 0; ei < dm.getNumEntities(); ++ei) {
            DiscourseEntity cde = dm.getEntity(ei);
            MentionContext cec = cde.getLastExtent();
            if (cec.getId() != mention.getId()) continue;
            this.distances.add(new Integer(ei));
            return cde;
        }
        return null;
    }

    protected String featureString(MentionContext mention) {
        StringBuffer fs = new StringBuffer();
        Object[] mtokens = mention.getTokens();
        fs.append(mtokens[0].toString());
        int tl = mtokens.length;
        for (int ti = 1; ti < tl; ++ti) {
            fs.append("_").append(mtokens[ti].toString());
        }
        return fs.toString();
    }

    protected String stripNp(MentionContext mention) {
        String type;
        int start = mention.getNonDescriptorStart();
        Parse[] mtokens = mention.getTokenParses();
        int end = mention.getHeadTokenIndex() + 1;
        if (start == end) {
            return null;
        }
        if (mtokens[start].getSyntacticType().equals("DT")) {
            ++start;
        }
        if (start == end) {
            return null;
        }
        for (int i = start; i < end && !(type = mtokens[start].getSyntacticType()).startsWith("NNP"); ++i) {
            ++start;
        }
        if (start == end) {
            return null;
        }
        if (start + 1 != end) {
            if (Linker.honorificsPattern.matcher(((Object)mtokens[start]).toString()).find()) {
                ++start;
            }
            if (start == end) {
                return null;
            }
            if (Linker.designatorsPattern.matcher(((Object)mtokens[mtokens.length - 1]).toString()).find()) {
                --end;
            }
        }
        if (start == end) {
            return null;
        }
        String strip = new String();
        for (int i = start; i < end; ++i) {
            strip = strip + ((Object)mtokens[i]).toString() + " ";
        }
        return strip.trim();
    }

    public void train() throws IOException {
    }

    public static String getPronounGender(String pronoun) {
        if (Linker.malePronounPattern.matcher(pronoun).matches()) {
            return "m";
        }
        if (Linker.femalePronounPattern.matcher(pronoun).matches()) {
            return "f";
        }
        if (Linker.neuterPronounPattern.matcher(pronoun).matches()) {
            return "n";
        }
        return "u";
    }
}

