% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_likelihoodEqs.R
\name{negLLsquash}
\alias{negLLsquash}
\title{Likelihood with data squashing and no zero counts}
\usage{
negLLsquash(theta, ni, ei, wi, N_star = 1)
}
\arguments{
\item{theta}{A numeric vector of hyperparameters ordered as:
\eqn{\alpha_1, \beta_1, \alpha_2, \beta_2, P}.}

\item{ni}{A whole number vector of squashed actual counts from
\code{\link{squashData}}.}

\item{ei}{A numeric vector of squashed expected counts from
\code{\link{squashData}}.}

\item{wi}{A whole number vector of bin weights from \code{\link{squashData}}.}

\item{N_star}{A scalar whole number for the minimum count size used.}
}
\value{
A scalar negative log-likelihood value
}
\description{
\code{negLLsquash} computes the negative log-likelihood based on the
conditional marginal distribution of the counts, \emph{N}, given that
\emph{N >= N*}, where \emph{N*} is the smallest count used for estimating the
hyperparameters. This function is minimized to estimate the hyperparameters
of the prior distribution. Use this function when zero counts are not used
and data squashing is used as described by DuMouchel et al. (2001). This
function is the likelihood function that should usually be chosen.
}
\details{
The conditional marginal distribution for the counts, \emph{N},
  given that \emph{N >= N*}, is based on a mixture of two negative binomial
  distributions. The hyperparameters for the prior distribution (mixture of
  gammas) are estimated by optimizing the likelihood equation from this
  conditional marginal distribution. It is recommended to use \code{N_star =
  1} when practical.

The hyperparameters are:
  \itemize{
    \item{\eqn{\alpha_1, \beta_1}: }{Parameters of the first component of the
      marginal distribution of the counts (also the prior distribution)}
    \item{\eqn{\alpha_2, \beta_2}: }{Parameters of the second component}
    \item{\eqn{P}: }{Mixture fraction}
}

This function will not need to be called directly if using
  \code{\link{exploreHypers}} or \code{\link{autoHyper}}.
}
\section{Warnings}{

  Make sure \emph{N_star} matches the smallest actual count in \emph{ni}
  before using this function. Filter \emph{ni}, \emph{ei}, and \emph{wi} if
  needed.


  Make sure the data were actually squashed (see \code{\link{squashData}})
  before using this function.
}

\examples{
theta_init <- c(0.2, 0.1, 2, 4, 1/3)  #initial guess
data(caers)
proc <- processRaw(caers)
squashed <- squashData(proc, count = 1, bin_size = 100, keep_bins = 1)
squashed <- squashData(squashed, count = 2, bin_size = 10)
negLLsquash(theta = theta_init, ni = squashed$N, ei = squashed$E,
            wi = squashed$weight)
#For hyperparameter estimation...
stats::nlminb(start = theta_init, objective = negLLsquash, ni = squashed$N,
              ei = squashed$E, wi = squashed$weight)

}
\references{
DuMouchel W, Pregibon D (2001). "Empirical Bayes Screening for
  Multi-item Associations." In \emph{Proceedings of the Seventh ACM SIGKDD
  International Conference on Knowledge Discovery and Data Mining}, KDD '01,
  pp. 67-76. ACM, New York, NY, USA. ISBN 1-58113-391-X.
}
\seealso{
\code{\link[stats]{nlm}}, \code{\link[stats]{nlminb}}, and
  \code{\link[stats]{optim}} for optimization and \code{\link{squashData}}
  for data squashing

Other negative log-likelihood functions: \code{\link{negLLzeroSquash}},
  \code{\link{negLLzero}}, \code{\link{negLL}}
}
\keyword{openEBGM}
