% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.R
\name{opal.post}
\alias{opal.post}
\title{Generic REST resource creation.}
\usage{
opal.post(
  opal,
  ...,
  query = list(),
  body = "",
  contentType = "application/x-rscript",
  acceptType = "application/json",
  callback = NULL
)
}
\arguments{
\item{opal}{Opal object.}

\item{...}{Resource path segments.}

\item{query}{Named list of query parameters.}

\item{body}{The body of the request.}

\item{contentType}{The type of the body content. Default is 'application/x-rscript'.}

\item{acceptType}{The type of the body content. Default is 'application/json', i.e. a serialized R object or an error message.}

\item{callback}{A callback function to handle the response object.}
}
\description{
Generic REST resource creation.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.post(o, 'some', 'resources', body='{"some":"value"}')
opal.logout(o)
}
}
\seealso{
Other REST functions: 
\code{\link{opal.delete}()},
\code{\link{opal.get}()},
\code{\link{opal.put}()}
}
\concept{REST functions}
