% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_term_set_to_term_sims}
\alias{get_term_set_to_term_sims}
\title{Get `term sets to term' similarity matrix}
\usage{
get_term_set_to_term_sims(term_sim_mat, term_sets)
}
\arguments{
\item{term_sim_mat}{Numeric matrix with rows and columns corresponding to (and named by) term IDs, and cells containing the similarity between the row and column term}

\item{term_sets}{List of character vectors of ontological term IDs.}
}
\value{
Numeric matrix of term set-to-term similarities
}
\description{
Using a matrix of between-term similarities (e.g. the kind obtained from applying the function \code{\link{get_term_sim_mat}}), create a numeric matrix of `term set-to-term' similarities using either the `best-match' approach (i.e. the similarity of the term will be the maximum term-to-term similarity in \code{term_sim_mat} amongst the term set terms).
}

