% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_envelope.R
\name{summarize_envelope}
\alias{summarize_envelope}
\title{summarize_envelope}
\usage{
summarize_envelope(x, plot_result = FALSE)
}
\arguments{
\item{x}{fv}

\item{plot_result}{A plot is drawn.}
}
\value{
env_summarized
}
\description{
Summarize simulation envelope
}
\details{
The area above and below the null model envelope is divided by the total area
under the curve. If \code{seperated = TRUE}, the first returning value is the
relative area above, the second value the relative value below the envelope.
If \code{seperated = FALSE} the value is the absolute sum of both ratio. If the
value is positive, the area above the envelope is larger than the value below
the envelope. If the value is negative, the area under the envelope is larger than
the value above the envelope.

The returned \code{env_summarized} object includes information about the area
under the curve where the summary function observed pattern is above or below
the null model envelopes.
}
\examples{
set.seed(42)
input_pattern <- spatstat.random::rThomas(kappa = 15, scale = 0.05, mu = 5)

cluster_env <- spatstat.explore::envelope(input_pattern, fun = "pcf", nsim = 39,
funargs = list(divisor = "d", correction = "Ripley", stoyan = 0.25))

summarize_envelope(cluster_env)

}
\seealso{
\code{\link{envelope}}
}
