% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{bspline}
\alias{bspline}
\title{Compute base splines of a variable using the R function \code{splines::bs}, use in the transform stage.}
\usage{
bspline(
  X,
  Boundary.knots = NA,
  intercept = FALSE,
  df = NULL,
  knots = NULL,
  degree = 3,
  bknots = NA,
  periodic = FALSE
)
}
\arguments{
\item{X}{data.frame (as part of data.list) with horizons as columns named \code{kxx} (i.e. one for each horizon)}

\item{Boundary.knots}{The value is NA: then the boundaries are set to the range of each horizons (columns in X). See \code{?splines::bs}}

\item{intercept}{See \code{?splines::bs}.}

\item{df}{See \code{?splines::bs}}

\item{knots}{See \code{?splines::bs}}

\item{degree}{See \code{?splines::bs}}

\item{bknots}{Is just a short for Boundary.knots and replace Boundary.knots (if Boundary.knots is not given)}

\item{periodic}{Default FALSE. If TRUE, then \code{pbs::pbs} is called and periodic splines are generated.}
}
\value{
List of data frames with the computed base splines, each with columns for the same horizons as in X
}
\description{
Simply wraps the \code{splines::bs}, such that it can be used in the transformation stage.
}
\details{
See the help for all arguments with \code{?splines::bs}. NOTE that two arguments have different default values.

See the example \url{https://onlineforecasting.org/examples/solar-power-forecasting.html} where the function is used in a model.
}
\examples{

# How to make a diurnal curve using splines
 # Select first 54 hours from the load data
 D <- subset(Dbuilding, 1:76, kseq=1:4)
 # Make the hour of the day as a forecast input
 D$tday <- make_tday(D$t, kseq=1:4)
 D$tday

 # Calculate the base splines for each column in tday
 L <- bspline(D$tday)

 # Now L holds a data.frame for each base spline
 str(L)
 # Hence this will result in four inputs for the regression model

 # Plot (note that the splines period starts at tday=0)
 plot(D$t, L$bs1$k1, type="s")
 for(i in 2:length(L)){
   lines(D$t, L[[i]]$k1, col=i, type="s")
 }

 # In a model formulation it will be:
 model <- forecastmodel$new()
 model$add_inputs(mutday = "bspline(tday)")
 # Such that at the transform stage will give the same as above
 model$transform_data(D)

# Periodic splines are useful for modelling a diurnal harmonical functions
L <- bspline(D$tday, bknots=c(0,24), df=4, periodic=TRUE)
# or
L <- pbspline(D$tday, bknots=c(0,24), df=4)
# Note, how it has to have high enough df, else it generates an error

# Plot
plot(D$t, L$bs1$k1, type="s")
for(i in 2:length(L)){
    lines(D$t, L[[i]]$k1, col=i, type="s")
}

}
\seealso{
Other Transform stage functions: 
\code{\link{pbspline}()}
}
\concept{Transform stage functions}
