% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_onemap.R
\name{combine_onemap}
\alias{combine_onemap}
\title{Combine OneMap datasets}
\usage{
combine_onemap(...)
}
\arguments{
\item{...}{Two or more \code{onemap} dataset objects of the same cross
type.}
}
\value{
An object of class \code{onemap}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}. Markers for F2 intercrosses are coded as 1; all other crosses
are left as \code{NA}.} \item{input}{a string indicating that this is a
combined dataset.} \item{n.phe}{number of phenotypes.} \item{pheno}{a
matrix with phenotypic values. Each column contains data for a trait and
each row represents an individual.}
}
\description{
Merge two or more OneMap datasets from the same cross type. Creates an
object of class \code{onemap}.
}
\details{
Given a set of OneMap datasets, all from the same cross type (full-sib,
backcross, F2 intercross or recombinant inbred lines obtained by self-
or sib-mating), merges marker and phenotype information to create a
single \code{onemap} object.

If sample IDs are present in all datasets (the standard new format), not
all individuals need to be genotyped in all datasets - the merged dataset
will contain all available information, with missing data elsewhere. If
sample IDs are missing in at least one dataset, it is required that all
datasets have the same number of individuals, and it is assumed that they
are arranged in the same order in every dataset.
}
\examples{

  \dontrun{
    combined_data <- combine_onemap(onemap_data1, onemap_data2)
  }
}
\references{
Lincoln, S. E., Daly, M. J. and Lander, E. S. (1993)
Constructing genetic linkage maps with MAPMAKER/EXP Version 3.0: a tutorial
and reference manual. \emph{A Whitehead Institute for Biomedical Research
Technical Report}.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.
}
\seealso{
\code{\link[onemap]{read_onemap}} and
\code{\link[onemap]{read_mapmaker}}.
}
\author{
Gabriel R A Margarido, \email{gramarga@gmail.com}
}
\keyword{IO}
