% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_fold_changes.R
\name{count_fold_changes}
\alias{count_fold_changes}
\title{Get counts for significant fold changes by metabolite class.}
\usage{
count_fold_changes(count_data, ..., column, sig_threshold, keep_unknowns)
}
\arguments{
\item{count_data}{Output dataframe from the omu_summary function}

\item{...}{Either a Class or Subclass column as a string, i.e. "Class}

\item{column}{The same value entered for the ... argument, i.e. column = "Class}

\item{sig_threshold}{Significance threshold for compounds that go towars the count,
sig_threshold = 0.05}

\item{keep_unknowns}{TRUE or FALSE for whether to drop compounds that weren't assigned
hierarchy metadata}
}
\description{
Takes an input data frame from the output of omu_summary and creates a
data frame of counts for significantly changed metabolites by class hierarchy data.
}
\examples{
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:30,]}
t_test_df <- omu_summary(count_data = c57_nos2KO_mouse_countDF,
metadata = c57_nos2KO_mouse_metadata,
numerator = "Strep", denominator = "Mock", response_variable = "Metabolite",
Factor = "Treatment", log_transform = TRUE, p_adjust = "BH", test_type = "welch")

fold_change_counts <- count_fold_changes(count_data = t_test_df, "Class",
column = "Class", sig_threshold = 0.05, keep_unknowns = "FALSE")
}
