% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmatchSafe.r
\name{pmatchSafe}
\alias{pmatchSafe}
\title{Partial matching of strings with error checking}
\usage{
pmatchSafe(
  x,
  table,
  useFirst = FALSE,
  error = TRUE,
  ignoreCase = TRUE,
  nmax = length(x),
  ...
)
}
\arguments{
\item{x}{Character: String to match.}

\item{table}{Character vector: Values to which to match.}

\item{useFirst}{Logical: If \code{TRUE}, and there is more than one match for a given \code{x}, then the first value in \code{table} that matches \code{x} will be returned (without an error or warning).}

\item{error}{Logical: If no match is found, return an error?}

\item{ignoreCase}{Logical: If \code{TRUE} (default), ignore the case of values in \code{x} and \code{table} when checking for matches.}

\item{nmax}{Positive numeric integer: Maximum allowable number of matches. If more than this number of matches is found, an error will be thrown (regardless of the value of \code{error}).}

\item{...}{Arguments to pass to \code{\link{pmatch}}.}
}
\value{
One or more of the values in \code{table}.
}
\description{
This function is the same as \code{\link{pmatch}}, but it can throw an error instead of \code{NA} if not match is found, and can be forced to throw the error if more than the desired number of matches is found.
}
\examples{

pmatchSafe('ap', c('apples', 'oranges', 'bananas'))

pmatchSafe('AP', c('apples', 'oranges', 'bananas'))

pmatchSafe('AP', c('apples', 'oranges', 'bananas'),
    ignoreCase = FALSE, error = FALSE)

pmatchSafe(c('ba', 'ap'), c('apples', 'oranges', 'bananas'))

# No match:
tryCatch(
    pmatchSafe('kumquats', c('apples', 'oranges', 'bananas')),
	error = function(cond) FALSE
)

pmatchSafe('kumquats', c('apples', 'oranges', 'bananas'), error = FALSE)

pmatchSafe(c('ap', 'corn'), c('apples', 'oranges', 'bananas'), error = FALSE)

# Too many matches:
tryCatch(
    pmatchSafe(c('ap', 'ba'), c('apples', 'oranges', 'bananas'), nmax = 1),
	error=function(cond) FALSE
)

}
