% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-regression.R
\name{ols_step_both_p}
\alias{ols_step_both_p}
\alias{ols_step_both_p.default}
\alias{plot.ols_step_both_p}
\title{Stepwise regression}
\usage{
ols_step_both_p(model, ...)

\method{ols_step_both_p}{default}(
  model,
  p_enter = 0.1,
  p_remove = 0.3,
  include = NULL,
  exclude = NULL,
  progress = FALSE,
  details = FALSE,
  ...
)

\method{plot}{ols_step_both_p}(x, model = NA, print_plot = TRUE, details = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{p_enter}{p value; variables with p value less than \code{p_enter} will enter
into the model.}

\item{p_remove}{p value; variables with p more than \code{p_remove} will be removed
from the model.}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_both_p}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_step_both_p} returns an object of class \code{"ols_step_both_p"}.
An object of class \code{"ols_step_both_p"} is a list containing the
following components:

\item{model}{final model; an object of class \code{lm}}
\item{metrics}{selection metrics}
\item{beta_pval}{beta and p values of models in each selection step}
}
\description{
Build regression model from a set of candidate predictor variables by
entering and removing predictors based on p values, in a stepwise manner
until there is no variable left to enter or remove any more.
}
\examples{
\dontrun{
# stepwise regression
model <- lm(y ~ ., data = surgical)
ols_step_both_p(model)

# stepwise regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_both_p(model)
plot(k)

# selection metrics
k$metrics

# final model
k$model

# include or exclude variables
model <- lm(y ~ ., data = stepdata)

# force variable to be included in selection process
ols_step_both_p(model, include = c("x6"))

# use index of variable instead of name
ols_step_both_p(model, include = c(6))

# force variable to be excluded from selection process
ols_step_both_p(model, exclude = c("x1"))

# use index of variable instead of name
ols_step_both_p(model, exclude = c(1))
}

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
\concept{both direction selection_procedures}
