% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{hyperlink_ftext}
\alias{hyperlink_ftext}
\title{Formatted chunk of text with hyperlink}
\usage{
hyperlink_ftext(text, prop = NULL, href)
}
\arguments{
\item{text}{text value, a single character value}

\item{prop}{formatting text properties returned by \link{fp_text}. It also can be NULL in
which case, no formatting is defined (the default is applied).}

\item{href}{URL value}
}
\description{
Format a chunk of text with text formatting properties (bold, color, ...),
the chunk is associated with an hyperlink.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{
ft <- fp_text(font.size = 12, bold = TRUE)
hyperlink_ftext(
  href = "https://cran.r-project.org/index.html",
  text = "some text", prop = ft)
}
\seealso{
Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_comment}()},
\code{\link{run_footnoteref}()},
\code{\link{run_footnote}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()},
\code{\link{run_wordtext}()}
}
\concept{run functions for reporting}
