% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_fpar}
\alias{body_add_fpar}
\title{add fpar}
\usage{
body_add_fpar(x, value, pos = "after")
}
\arguments{
\item{x}{a docx device}

\item{value}{a character}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
add an \code{fpar} (a formatted paragraph) into an rdocx object
}
\examples{
library(magrittr)
bold_face <- shortcuts$fp_bold(font.size = 30)
bold_redface <- update(bold_face, color = "red")
fpar_ <- fpar(ftext("Hello ", prop = bold_face),
              ftext("World", prop = bold_redface ),
              ftext(", how are you?", prop = bold_face ) )
doc <- read_docx() \%>\% body_add_fpar(fpar_)

print(doc, target = "body_add_fpar.docx" )
}
\seealso{
\code{\link{fpar}}
}
