% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frame_helpers.R
\name{group_data_frame}
\alias{group_data_frame}
\title{Grouping of a \code{data.frame}}
\usage{
group_data_frame(df, by, keep_by = TRUE)
}
\arguments{
\item{df}{A \code{data.frame}.}

\item{by}{A \code{character}, the name of a column of \code{df} to group by.}

\item{keep_by}{Either \code{TRUE} (default) to keep the grouping column \code{by}, or
\code{FALSE}, else.}
}
\value{
A \code{list} of \code{data.frame}s, subsets of \code{df}.
}
\description{
This function groups a \code{data.frame} according to values of one column.
}
\examples{
df <- data.frame("label" = c("A", "B"), "number" = 1:10)
group_data_frame(df = df, by = "label")
group_data_frame(df = df, by = "label", keep_by = FALSE)

}
