\name{plot2d.prism}
\alias{plot2d.prism}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Function to plot the performance (accuracy, precision and statistical power) as a function of the number of individuals (x-axis) and replicates (y-axis) sampled.}
\description{
Function to plot the performance (accuracy, precision and statistical power) as a function of either the number of individuals or number of replicates sampled, while keeping the other constant. The function only plots dataframes of class 'odprism' that can be generated with the functions 'odprim', 'odpsrimB' and 'odprismU'.  The function plots the values of the median (blue points) and the inner percentiles (green lines) and outer percentile (red lines) that are determined by the argument \code{Quant=c(0.025,0.25,0.75,0.975)}, while the value used to simulate the data is depicted by a horizontal straight black line. Power is calculated as the proportion of simulations in which the variable of interest was significant at the level given by \code{alpha} in the simulation function. }
\usage{
plot2d.prism(x, variable, xvar = "G", cons, ylim1 = c(0, 0))
}

\arguments{
   \item{x}{ dataframe of class 'odprism' that can be generated by the functions 'odprim', 'odprismB' and 'odprismU'. }
  \item{variable}{ Variable from the mixed model applied to the data, e.g. 'b0, bX, bX2, VI, VS, C (coding for either CorIS or CovIS) or VR. }
  \item{xvar}{ If \code{xvar = "G"} grouping units are plotted on the x-axis and the number of replicates per grouping units is kept constant at value of \code{cons}. 
  If \code{xvar = "R"} number of replicates per grouping unit are plotted on the x-axis and the number of grouping units is kept constant at value of \code{cons}. Default: \code{xvar = "G"}.}
  \item{cons}{ Value of grouping units or replicates that is kept constant. }
  \item{ylim1}{ Describes the range over which values of parameter estimates are plotted on the y-axis. If no values are given than it will automatically use the entire observed range.}
}
\details{
If results were generated with the option \code{alpha=0} then the results for statistical power cannot be plotted.
}
\value{  Plots one or two graphs. Left panel: the distribution of parameter estimates described by the percentile plots. Right panel: statistical power.}
\references{
 van de Pol, M. 2012 Quantifying individual reaction norms: How study design affects the accuracy, precision and power of random regression models. Methods in Ecology & Evolution, In press.
}
\author{
Martijn van de Pol
}

\seealso{
\code{\link{odprim}}, \code{\link{odprismU}}, \code{\link{odprismB}}, \code{\link{plot3d.prism}}, \code{\link{DataExample}}
}
\examples{
## Note example uses only few sims to speed things up, normally sims>1000
results<-odprismB(indiv=c(10,25,50,75,100), repl=c(2,4,6,8,10), 
  random=c(0.2,0.1,0.5), sims=10, alpha=0.05)
results
plot2d.prism(x=results, variable="VI", xvar="G", cons=10)

## Alternatively look at an example datafile DataExample, 
## which is available with the package as an example.
## ensure that class(DataExample) = c("odprism", "data.frame")
## then run: plot2d.prism(x=DataExample, variable="VI", xvar="R", cons=100)
}
\keyword{ models}
\keyword{ methods}
