% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get data from a resource.}
\usage{
get_data(resource, fields = NULL, limit = NULL, where = NULL, page_size = NULL)
}
\arguments{
\item{resource}{A character string containing the resource id of the data set
to be returned.}

\item{fields}{A character vector containing the names of fields to be
included in the returned table. The input is checked to ensure the specified
fields exist in the chosen resource.}

\item{limit}{An integer specifying the maximum number of records to be
returned, the default NULL value returns all records.}

\item{where}{A character string containing the 'WHERE' element of a simple
SQL SELECT style query. Field names must be double quoted ",
non-numeric values must be single quoted ', and both single and
double quotes must be delimited. Example; \code{where = "\"AgeGroup\" = 
 \'45-49 years\'"}.}

\item{page_size}{An integer specifying the maximum number of records to be
returned per query. Setting a value causes the use of offset pagination,
multiple queries will be sent to return subsets of the available data.
Subsets are joined before being returned. The default NULL value will always
attempt to return all rows with a single query.}
}
\value{
A data.frame.
}
\description{
Get data from a resource in tabular format with the option to
select fields and perform basic filtering. Where multiple data sets are
required from a package and/or no field selection and filtering is required
the \code{get_resource} function can be used.
}
\examples{
\dontrun{
get_data(resource = "edee9731-daf7-4e0d-b525-e4c1469b8f69")

get_data(
  resource = "edee9731-daf7-4e0d-b525-e4c1469b8f69",
  fields = c("AgeGroup", "EuropeanStandardPopulation"),
  where = "\"AgeGroup\" = \'45-49 years\'"
)
}

}
