
<!-- README.md is generated from README.Rmd. Please edit that file -->

# odeGUTS

<!-- badges: start -->

[![R-CMD-check](https://github.com/bgoussen/odeGUTS/workflows/R-CMD-check/badge.svg)](https://github.com/bgoussen/odeGUTS/actions)
[![Lifecycle:
stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
<!-- badges: end -->

The goal of odeGUTS is to offer ode solver for the GUTS-RED-SD and
GUTS-RED-IT model without dependency to the “morse” package

## Installation

You can install the released version of odeGUTS from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("odeGUTS")
```

And the development version from [GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("bgoussen/odeGUTS")
```

## Example

This is a basic example which shows you how to solve a common problem:

``` r
library(odeGUTS)
dataPredict <- data.frame(time = c(1:5, 1:10, 1:15), 
                          conc = c(rep(5, 5), 
                                  c(rep(0, 3), rep(12, 4), rep(0, 3)), 
                                  rep(15, 15)),  
                          replicate = c(rep("rep1", 5), rep("rep2", 10), rep("rep3", 15))) # Prepare data for forwards prediction
data(fit_odeGUTS)
out <- predict_ode(fit_odeGUTS, dataPredict)
```

<!-- What is special about using `README.Rmd` instead of just `README.md`? You can include R chunks like so: -->
<!-- ```{r cars} -->
<!-- summary(cars) -->
<!-- ``` -->
<!-- You'll still need to render `README.Rmd` regularly, to keep `README.md` up-to-date. `devtools::build_readme()` is handy for this. You could also use GitHub Actions to re-render `README.Rmd` every time you push. An example workflow can be found here: <https://github.com/r-lib/actions/tree/master/examples>. -->
<!-- You can also embed plots, for example: -->
<!-- ```{r pressure, echo = FALSE} -->
<!-- plot(pressure) -->
<!-- ``` -->
<!-- In that case, don't forget to commit and push the resulting figure files, so they display on GitHub and CRAN. -->
