% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soi.R
\docType{data}
\name{soi}
\alias{soi}
\title{Southern Oscillation Index}
\usage{
data(soi, package="ocedata")
}
\description{
\code{soi} is a data frame containing the Southern Oscillation Index with
columns named \code{year} for decimal year (sampled monthly and represented
at mid-month) and \code{index} for the index.
}
\details{
The data were downloaded on August 11, 2017, and processed as follows.\if{html}{\out{<div class="sourceCode R">}}\preformatted{library(ncdf4)
url <- "https://www.cgd.ucar.edu/cas/catalog/climind/SOI.nc"
download.file(url, "SOI.nc")
f <- nc_open("SOI.nc")
year <- as.vector(ncvar_get(f, "TIME"))
index <- as.vector(ncvar_get(f, "SOI_SIGNAL"))
ok <- is.finite(index)
year <- year[ok]
index <- index[ok]
soi <- data.frame(year=year, index=index)
}\if{html}{\out{</div>}}
}
\examples{
data(soi, package="ocedata")
recent <- subset(soi, year > 1950)
plot(recent$year, recent$index, type='l', xlab="Year", ylab="SOI")
}
