% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastlineWorldFine.R
\docType{data}
\name{coastlineWorldFine}
\alias{coastlineWorldFine}
\title{World coastline at fine-scale (1:10M) resolution}
\usage{
data(coastlineWorldFine, package="ocedata")
}
\description{
\code{coastlineWorldFine} is analogous to \code{\link{coastlineWorldMedium}}, but
at higher resolution, i.e. showing more detail.  It may be used for regional
(sub-basin) views, but for coastal work, users should consider downloading a
file at finer resolution.
}
\details{
The data for \code{coastlineWorldFine} were downloaded from shapefile
\code{ne_10m_admin_0_countries.shp}, stored at
\url{https://www.naturalearthdata.com}.

The documentation for \code{coastline-class} in \CRANpkg{oce} explains the
structure of coastline objects and discusses functions that deal with them.
}
\examples{
# Regional plot of the Maritime provinces of Canada.
data(coastlineWorldFine, package="ocedata")
\dontrun{
library(oce)
plot(coastlineWorldFine, clongitude=-63, clatitude=45.5, span=600)
}
}
\seealso{
Other coastline files: 
\code{\link{coastlineWorldMedium}}
}
\concept{coastline files}
