\name{plot}
\alias{plot_ronds}
\alias{plot_classes}
\alias{plot_ronds_classes}
\alias{plot_classes_ronds}
\alias{plot_typo}
\alias{plot_typo_symboles}
\alias{plot_oursins}
\alias{plot_joignantes}
\alias{plot_saphirs}
\title{
	Creation maps in plot
}
\description{
	Displays the map in a plot output.
}
\usage{
plot_ronds(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL, idData,
varVolume, rayonRond = NULL, rapportRond = NULL, emprise = "FRM", fondChx = NULL,
precisionLegRonds = 0, titreLeg = "", xLeg = NULL, yLeg = NULL,
titreCarte = "", sourceCarte = "", etiquettes = NULL, colPos = "#CD853F",
colNeg = "#6495ED", colBorder = "white", colBorderMaille = "black",
xlim = NULL, ylim = NULL)

plot_classes(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL, idData,
varRatio,  methode = "kmeans", nbClasses = 3, bornes = NULL,
precisionLegClasses = 1, titreLeg = "", xLeg = NULL, yLeg = NULL,
titreCarte = "", sourceCarte = "", etiquettes = NULL,
stylePalette = "defaut", palettePos = NULL, paletteNeg = NULL,
colBorder = "white", xlim = NULL, ylim = NULL)

plot_ronds_classes(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL,
idData, varVolume, varRatio, rayonRond = NULL, rapportRond = NULL,
methode = "kmeans", nbClasses = 3, bornes = NULL,
precisionLegRonds = 0, precisionLegClasses = 1, emprise = "FRM",
fondChx = NULL, titreLegRonds = "", titreLegClasses = "",
xLegRonds = NULL, yLegRonds = NULL, xLegClasses = NULL,
yLegClasses = NULL, titreCarte = "", sourceCarte = "",
etiquettes = NULL, stylePalette = "defaut", palettePos = NULL,
paletteNeg = NULL, colBorder = "white", colBorderMaille = "black",
xlim = NULL, ylim = NULL)

plot_classes_ronds(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL,
idData, varVolume, varRatio, rayonRond = NULL, rapportRond = NULL,
methode = "kmeans", nbClasses = 3, bornes = NULL,
precisionLegRonds = 0, precisionLegClasses = 1, emprise = "FRM",
fondChx = NULL, titreLegRonds = "", titreLegClasses = "",
xLegRonds = NULL, yLegRonds = NULL, xLegClasses = NULL,
yLegClasses = NULL, titreCarte = "", sourceCarte = "",
etiquettes = NULL, stylePalette = "defaut", palettePos = NULL,
paletteNeg = NULL, colBorder = "white", colBorderRonds = "#303030",
xlim = NULL, ylim = NULL)

plot_typo(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL, idData,
varTypo, titreLeg = "", xLeg = NULL, yLeg = NULL, titreCarte = "",
sourceCarte = "", etiquettes = NULL, paletteTypo = NULL, labels = NULL,
colBorder = "white", xlim = NULL, ylim = NULL)

plot_typo_symboles(fondPoints, listFonds, emprise = "FRM", types = NULL,
couleurs = NULL, tailles = NULL, epaisseurs = NULL, titreLeg = "", xLeg = NULL,
yLeg = NULL, titreCarte = "", sourceCarte = "", etiquettes = NULL, labels = NULL,
xlim = NULL, ylim = NULL)

plot_oursins(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL,
idDataDepart, idDataArrivee, varFlux, filtreVol = 0, filtreDist = 100,
filtreMajeurs = 10, decalageAllerRetour = 0, decalageCentroid = 0,
titreCarte = "", sourceCarte = "", etiquettes = NULL, epaisseur = 2,
colTrait = "black", colBorderMaille = "black", xlim = NULL, ylim = NULL)

plot_joignantes(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL,
typeMaille, idDataDepart, idDataArrivee, varFlux,
largeurFlecheMax = NULL, filtreVol = 0, filtreDist = 100,
filtreMajeurs = 10, decalageAllerRetour = 0, decalageCentroid = 0,
emprise = "FRM", precisionLegFleches = 0, titreLeg = "",
xLeg = NULL, yLeg = NULL, titreCarte = "", sourceCarte = "",
etiquettes = NULL, colFleche = "#CD853F",
colBorder = "white", colBorderMaille = "black", xlim = NULL, ylim = NULL)

plot_saphirs(data, fondMaille, fondSousAnalyse = NULL, fondSurAnalyse = NULL,
typeMaille, idDataDepart, idDataArrivee, varFlux, largeurFlecheMax = NULL,
direction = "Ent", filtreVol = 0, emprise = "FRM",  precisionLegFleches = 0,
titreLeg = "", xLeg = NULL, yLeg = NULL, titreCarte = "", sourceCarte = "",
etiquettes = NULL, colEntree = "#CD853F", colSortie = "#6495ED",
colBorder = "white",  colBorderMaille = "black", xlim = NULL, ylim = NULL)
}
\arguments{
\item{data}{
	tableau de donnees (data.frame).
}
  \item{fondMaille}{
	objet sf. Fond de carte.
}
  \item{typeMaille}{
	chaine de caracteres (character). Type de maille issus d'un zonage administratifs ou d'etudes ("REG", "DEP", "UU", "AU", "ZE", "BV", "EPCI" ou "COM").
}
  \item{fondSousAnalyse}{
	list d'objets sf. Liste de fonds de carte a ajouter en-dessous de l'analyse. Par exemple, un fond de mer et des pays frontaliers. Par defaut a NULL.
}
  \item{fondPoints}{
	objets sf. Fond de points.
}
  \item{fondSurAnalyse}{
	list d'objets sf. Liste de fonds de carte a ajouter au-dessus de l'analyse. Par exemple, un fond de departement. Par defaut a NULL.
}
  \item{listFonds}{
	list d'objets sf. Liste de fonds de carte a ajouter.
}
  \item{idData}{
	chaine de caracteres (character). Variable identifiant la maille.
}
  \item{idDataDepart}{
	chaine de caracteres (character). Variable identifiant le territoire de depart du flux.
}
  \item{idDataArrivee}{
	chaine de caracteres (character). Variable identifiant le territoire d'arrivee du flux.
}
  \item{varVolume}{
	chaine de caracteres (character). Variable en volume pour des ronds proportionnels.
}
  \item{varRatio}{
	chaine de caracteres (character). Variable en ratio pour des analyses en classes.
}
  \item{varTypo}{
	chaine de caracteres (character). Variable de typologie.
}
  \item{varFlux}{
	chaine de caracteres (character). Variable de flux pour des oursins, fleches joignantes ou fleches saphirs.
}
  \item{rayonRond}{
	valeur numerique (numeric). Rayon du rond le plus grand en metres.
}
  \item{rapportRond}{
	valeur numerique (numeric). Rapport entre l'aire du rond le plus grand et la valeur maximale des donnees en volume.
}
  \item{methode}{
	chaine de caracteres (character). A choisir parmi "kmeans" (par defaut), "fisher", "jenks" ou "quantile".
}
  \item{nbClasses}{
	valeur numerique (numeric). Nombre de classes. Par defaut 3 classes.
}
  \item{bornes}{
	vecteur de valeurs numeriques (numeric). Le nombre de bornes correspond au nombre de classes -1. Par defaut a NULL.
}
  \item{precisionLegRonds}{
	valeur numerique (numeric). Arrondit les valeurs de la legende des ronds. 0 (par defaut) pour arrondir a l'unite, -1 pour arrondir a la dizaine, -2 a la centaine...
}
  \item{precisionLegClasses}{
	valeur numerique (numeric). Arrondit les valeurs en ratio pour le calcul des bornes de classes. Par defaut, 1 chiffre apres la virgule.
}
  \item{precisionLegFleches}{
	valeur numerique (numeric). Arrondit les valeurs de la legende des fleches. 0 (par defaut) pour arrondir a l'unite, -1 pour arrondir a la dizaine, -2 a la centaine...
}
  \item{largeurFlecheMax}{
	valeur numerique (numeric). Valeur relative correspondant a la largeur de la fleche la plus grande de la carte. Par defaut a NULL.
}
  \item{direction}{
	chaine de caracteres (character). Pour les fleches saphirs, type de flux a choisir parmi "Ent" pour entrees (par defaut), "Sor" pour sorties et "Sol" pour soldes (entrees - sorties).
}
  \item{filtreVol}{
	valeur numerique (numeric). Filtre des valeurs en volume de flux. Par defaut a 0 : affichage de tous les flux.
}
  \item{filtreDist}{
	valeur numerique (numeric). Filtre sur la distance des fleches pour les oursins et les fleches joignantes. Par defaut a 100 km : affichage des flux a moins de 100 km.
}
  \item{filtreMajeurs}{
	valeur numerique (numeric). Filtre sur les flux entrants et sortants les plus importants d'un territoire. Par defaut a 10 : 10 flux maximum sortent d'un territoire ou en entrent.
}
  \item{decalageAllerRetour}{
	valeur numerique (numeric). Decalage entre les fleches aller-retour (km).
}
  \item{decalageCentroid}{
	valeur numerique (numeric). Decalage des fleches depuis et vers les centroides des territoires (km).
}
  \item{emprise}{
	chaine de caracteres (character). "FRM" (par defaut pour la France metropolitaine), "971" (Guadeloupe), "972" (Martinique), "973" (Guyane), "974" (La Reunion) ou "976" (Mayotte). Ce parametre permet de definir le systeme de projection de la carte.
}
  \item{fondChx}{
	objet sf. Fond des chefs-lieux. Pour les ronds proportionnels avec une maille communale uniquement, choix entre position du centre des ronds sur les centroides des communes (NULL par defaut) ou sur les chefs-lieux (chx) des communes.
}
  \item{types}{
	vecteur de numeriques (numeric). Par defaut a NULL. Voir details.
}
  \item{couleurs}{
	vecteur de caracteres (character). Par defaut a NULL. Voir details.
}
  \item{tailles}{
	vecteur de numeriques (numeric). Par defaut a NULL. Voir details.
}
  \item{epaisseurs}{
	vecteur de numeriques (numeric). Par defaut a NULL. Voir details.
}
  \item{titreLeg}{
	chaine de caracteres (character). Titre de la legende.
}
  \item{xLeg}{
	valeur numerique (numeric). Coordonnees x de la legende dans le systeme de projection locale. Par defaut a NULL.
}
  \item{yLeg}{
	valeur numerique (numeric). Coordonnees y de la legende dans le systeme de projection locale. Par defaut a NULL.
}
  \item{titreLegRonds}{
	chaine de caracteres (character). Titre de la legende des ronds.
}
  \item{xLegRonds}{
	valeur numerique (numeric). Coordonnees x de la legende des ronds dans le systeme de projection locale. Par defaut a NULL.
}
  \item{yLegRonds}{
	valeur numerique (numeric). Coordonnees y de la legende des ronds dans le systeme de projection locale. Par defaut a NULL.
}
  \item{titreLegClasses}{
	chaine de caracteres (character). Titre de la legende des classes.
}
  \item{xLegClasses}{
	valeur numerique (numeric). Coordonnees x de la legende des classes dans le systeme de projection locale. Par defaut a NULL.
}
  \item{yLegClasses}{
	valeur numerique (numeric). Coordonnees y de la legende des classes dans le systeme de projection locale. Par defaut a NULL.
}
  \item{titreCarte}{
	chaine de caracteres (character). Titre de la carte.
}
  \item{sourceCarte}{
	chaine de caracteres (character). Source de la carte.
}
  \item{etiquettes}{
	vecteur de caracteres (character) ou tableau de donnees (data.frame). Liste des codes de la maille dont on affiche le libelle sur la carte. Par defaut a NULL. Voir details.
}
  \item{colPos}{
	chaine de caracteres (character). Couleur nommee (par exemple "orange") ou hexadecimal (par exemple "#FFA500"). Par defaut "#CD853F".
}
  \item{colNeg}{
	chaine de caracteres (character). Couleur nommee (par exemple "blue") ou hexadecimal (par exemple "#0000FF"). Par defaut "#6495ED".
}
  \item{stylePalette}{
	chaine de caracteres (character). Palette de la charte INSEE. A choisir entre "InseeFlash", "InseeAnalyse", "InseeDossier", "InseePremiere" ou "defaut" (par defaut).
}
  \item{palettePos}{
	vecteur de caracteres (character). Couleurs nommees (par exemple c("red","orange","yellow")) ou hexadecimal (par exemple c("#FFA500")). Par defaut a NULL.
}
  \item{paletteNeg}{
	vecteur de caracteres (character). Couleurs nommees (par exemple c("purple","blue","green")) ou hexadecimal (par exemple c("#800080","#0000FF","#008000")). Par defaut a NULL.
}
  \item{paletteTypo}{
	vecteur de caracteres (character). Couleurs nommees (par exemple c("red","blue","green")) ou hexadecimal (par exemple c("#FFA500","#0000FF","#008000")). Par defaut a NULL.
}
  \item{labels}{
	vecteur de caracteres (character). Labels personnalises pour la legende de la carte en typologie. Par defaut a NULL.
}
  \item{epaisseur}{
	valeur numerique (numeric). Epaisseur des traits des oursins. Par defaut 2.
}
  \item{colBorder}{
	chaine de caracteres (character). Couleur nommee (par exemple "white") ou hexadecimal (par exemple "#FFFFFF"). Par defaut "white".
}
  \item{colTrait}{
	chaine de caracteres (character). Couleur nommee (par exemple "black") ou hexadecimal (par exemple "#000000"). Par defaut "black".
}
  \item{colBorderMaille}{
	chaine de caracteres (character). Couleur nommee (par exemple "grey") ou hexadecimal (par exemple "#808080"). Par defaut "black".
}
  \item{colBorderRonds}{
	chaine de caracteres (character). Couleur nommee (par exemple "grey") ou hexadecimal (par exemple "#808080"). Par defaut "#303030".
}
  \item{colFleche}{
	chaine de caracteres (character). Couleur nommee (par exemple "orange") ou hexadecimal (par exemple "#FFA500"). Par defaut "#CD853F".
}
  \item{colEntree}{
	chaine de caracteres (character). Couleur nommee (par exemple "orange") ou hexadecimal (par exemple "#FFA500"). Par defaut "#CD853F".
}
  \item{colSortie}{
	chaine de caracteres (character). Couleur nommee (par exemple "blue") ou hexadecimal (par exemple "#0000FF"). Par defaut "#6495ED".
}
  \item{xlim}{
	vecteur de numeriques (numeric). Coordonnees xmin et xmax de la carte. Par defaut a NULL.
}
  \item{ylim}{
	vecteur de numerique (numeric). Coordonnees ymin et ymax de la carte. Par defaut a NULL.
}
}
\details{
	Les cartes en sortie "plot" ne sont pas interactives. Il faut eviter de zoomer sur la carte au risque de voir apparaitre des decalages entre les couches.
	
	Elles peuvent etre personnalisees grace aux parametres de style des fonctions plot_().
	
  \describe{
	\item{Ronds proportionnels}{
		L'interieur des cercles est de couleur orange (couleur par defaut) pour representer les valeurs positives de la variable en volume et bleu pour les valeurs negatives.
		
		Le parametre \code{fondChx} est a renseigner UNIQUEMENT si la maille est communale.
		
		Pour information, le chef-lieu (ou chx) est un point de la commune autour duquel la population est la plus dense. Le plus souvent, il s'agit de l'hotel de ville de la commune.
	}
	
	\item{Analyse en classes}{
		En semiologie, il est deconseille de multiplier le nombre de classes pour des raisons de visibilite et de clarte de la carte.
		
		Si les donnees ne comprennnent que des valeurs positives ou que des valeurs negatives, il est conseille 5 classes au maximum.
		
		Si les donnees comprennnent a la fois des valeurs positives et negatives, le nombre maximum conseille est 9 classes.
		
		Il est possible de specifier manuellement les bornes des classes en implementant le parametre \code{bornes} d'un vecteur de valeurs numeriques de type c(bornes1,bornes2,...). Le nombre de bornes correspond au nombre de classes -1 \code{(length(bornes)==nbClasses-1)}. Il n'est pas obligatoire de specifier les valeurs min et max.
	}
	
	\item{Analyse en classes dans ronds proportionnels}{
		L'analyse en classes colore l'interieur des ronds : (fonction \code{plot_ronds_classes()})
	}
	
	\item{Ronds proportionnels sur analyse en classes}{
		Les ronds proportionnels sont poses sur l'analyse en classes : (fonction \code{plot_classes_ronds()})
	}
	
	\item{Typologie}{
		Meme conseil que pour les analyses en classes. Le choix des couleurs ne doit pas etre un degrade si il n'existe pas de classement dans les modalites.
		
		Il est possible de specifier ses propres labels sans avoir besoin de modifier les noms de variables dans la table de donnees.
	}
	
	\item{Typologie en symboles}{
		Les fonds de carte doivent etre passes en list et peuvent etre personnalises (voir ci-dessous modifier l'apparence des fonds).
		
		Les parametres types, couleurs, tailles et epaisseurs sont des vecteurs de meme longueur. Chaque element correspond a un point du fond fourni. Verifier bien l'ordre des points pour modifier leur apparence ensuite.
		
		Il existe differents types de points (voir l'aide de ?graphics::points).
	}
	
	\item{Oursins}{
		Les oursins representent uniquement l'existence d'un flux entre 2 territoires. Le sens du flux et le volume ne sont pas pris en compte.
		
		Les filtres sur le volume, la distance et les flux majeurs sont independants. Chacun d'eux s'appliquent sur les donnees initiales. Autrement dit, le filtre sur les flux majeurs ne se fera pas apres un eventuel filtre sur la distance mais sur toutes les donnees en entree.
		
		Le filtre sur le volume est plutot complementaire au filtre sur les flux majeurs. En effet, il est possible de vouloir representer des faibles flux significatifs. Le filtre sur les flux majeurs le permet contrairement au filtre sur le volume seul.
	}
	
	\item{Fleches joignantes}{
		Les fleches joignantes representent un flux entre 2 territoires, son sens et son volume. Dans le cas de flux aller et retour, deux fleches de sens oppose sont superposees.
		
		La regle des filtres est la meme que pour les oursins.
	}
	
	\item{Fleches saphirs}{
		Les fleches saphirs convergent vers ou divergent d'un meme territoire. Elles permettent de representer les entrees, les sorties ou le solde (entrees - sorties) d'un territoire par rapport aux autres.
		
		Pour un solde positif, les fleches sont representees en orange, pour un solde negatif en bleu.
		
		Une attention particuliere est a apporter au choix de la variable idDataDepart et idDataArrivee selon si le flux est entrant, sortant ou en solde.
	}
}
  
	La legende est positionnee par defaut sur la carte si les coordonnees x et y ne sont pas specifiees. Elle est positionnee en haut a droite de la carte sauf pour l'analyse en classes ou elle est positionnee en bas a droite.
	
	Les coordonnees x et y doivent etre dans le systeme de projection locale :
	\itemize{
		\item France metropolitaine : Lambert 93 (code epsg 2154)
        \item Guadeloupe : UTM 20 N (code epsg 32620)
        \item Martinique : UTM 20 N (code epsg 32620)
        \item Guyane : UTM 22 N (code epsg 2972)
        \item La Reunion : UTM 40 S (code epsg 2975)
        \item Mayotte : UTM 38 S (code epsg 4471)
	}
	
	Il est possible d'ajouter des fonds de carte pour l'habiller. Il y existe 2 parametres : \code{fondSousAnalyse} et \code{fondSurAnalyse}.
	
	Le parametre \code{fondSousAnalyse} permet d'ajouter des fonds en-dessous de l'analyse et la parametre \code{fondSurAnalyse} au-dessus.
	
	Chacun de ces parametres est une liste d'objets sf. Par defaut, la couleur de remplissage est transparente, la bordure est noire et l'epaisseur est de 1.
	
	Pour modifier l'apparence de ces fonds, il faut ajouter des colonnes dans les objets sf correspondants :
	
	\itemize{
		\item COL : un colonne COL pour modifier la couleur de remplissage.
        \item BORDER : une colonne BORDER pour modifier la couleur de la bordure.
        \item EPAISSEUR : une colonne EPAISSEUR pour modifier l'epaisseur de la bordure.
	}
	
	Pour ajouter des colonnes un objet sf, il faut utiliser la fonction \code{cbind}. Exemple : paysf <- cbind(paysf, COL="grey", BORDER="#404040", EPAISSEUR=2)
	
	\describe{
		\item{etiquettes}{
			Des etiquettes peuvent etre affichees sur les cartes en plot grace au parametre "etiquettes". Comment proceder ?
			
				- Specifier un vecteur de codes des territoires a etiqueter appartenant a la maille. La fonction recupere les libelles a afficher. Les etiquettes se placent au centroide des territoires, reperes par leurs coordonnees x et y. Une mise en forme des etiquettes par defaut est proposee.
				
				- Pour formater les etiquettes, il est utile de passer par la fonction \code{\link{coordonnees_etiquettes}}. A partir d'un fond de maille et d'un vecteur de codes, un data.frame est produit en sortie de la fonction.
				
					Ce tableau contient le code du territoire, le libelle a afficher, les coordonnees x et y du centroide du territoire (position des etiquettes X et Y), la taille (TAILLE), le style (FONT) et la couleur de la police (COL). Le style de police est un entier : 1 (normal), 2 (gras, par defaut), 3 (italique) et 4 (gras italique).
					
					Il est possible de modifier les valeurs du tableau pour changer le style d'une ou plusieurs etiquettes.
					
					Il est egalement possible de modifier les coordonnees x et y pour deplacer les etiquettes et ainsi eviter leur chevauchement.
				
				- Pour afficher la carte avec les etiquettes formatees, il faut passer ce tableau dans le parametre "etiquettes" de la fonction plot.
		}
	}
	
	Il est tout de meme possible de zoomer sur la carte en specifiant les parametres xlim et ylim. Par defaut, la carte est centree sur le fond de maille. Pour connaitre les limites par defaut, executer la fonction \code{sf::st_bbox(fondMaille)}
}
\value{
	Retourne un objet sf. Il s'agit du fond des ronds (ronds proportionnels, classes dans ronds proportionnels, ronds sur analyse en classes), de la maille (analyse en classes, typologie) ou des fleches (oursins, fleches joignantes, fleches saphirs).
	
	Affiche dans le plot la carte demandee.
}
\seealso{
	\code{\link{zonage_a_facon},}
	
	\code{\link{coordonnees_etiquettes},}
	
	\code{\link{rayon_ronds}, \link{rapport_ronds}, \link{largeur_fleche},}
	
	\code{\link{calcul_ratio}, \link{calcul_tx_evol_global}, \link{calcul_tx_evol_ann_moy}, \link{calcul_part_ens}, \link{calculette},}
	
	\code{\link{distrib_variable},}
	
	\code{\link{recup_palette}}
}
\examples{
data("donnees_monoloc")
data("depm")

# Ronds proportionnels sur une analyse en classes
fond_ronds <- plot_classes_ronds(data = donnees_monoloc, fondMaille = depm,
idData = "COD_DEP", varVolume = "POP_2015", varRatio = "VAR_AN_MOY", nbClasses = 4,
titreLegRonds = "POP_2015", titreLegClasses = "VAR_AN_MOY",
xLegClasses = 1150000, yLegClasses = 6600000)

etiquettes <- coordonnees_etiquettes(fondMaille = depm,
listeCode = c("06","13","31","33","44","67","69","59","75"))
etiquettes$LIBELLE <- c("Nice","Marseille","Toulouse","Bordeaux","Nantes","Lille",
"Strasbourg","Lyon","Paris")
etiquettes[etiquettes$CODE=="75","TAILLE"] <- 1.5

# Ronds proportionnels sur une analyse en classes
fond_ronds <- plot_classes_ronds(data = donnees_monoloc, fondMaille = depm,
idData = "COD_DEP", varVolume = "POP_2015", varRatio = "VAR_AN_MOY", nbClasses = 4,
titreLegRonds = "POP_2015", titreLegClasses = "VAR_AN_MOY",
xLegClasses = 1150000, yLegClasses = 6600000,
etiquettes = etiquettes)
}
\keyword{documentation}
