% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceTest.R
\name{oceTest}
\alias{oceTest}
\title{Tests for ordered composite endpoints with censoring.}
\usage{
oceTest(
  data,
  oceTime,
  oceStatus,
  group,
  id = NULL,
  oceNames = NULL,
  method = c("all", "npmle", "coxph", "simple"),
  ciMethod = c("WLW", "bootstrap"),
  conf.int = FALSE,
  conf.level = 0.95,
  nBoot = 2000,
  plot = FALSE,
  ...
)
}
\arguments{
\item{data}{data.frame name, must have variables with names listed in
\code{oceTime}, \code{oceStatus}, \code{group}}

\item{oceTime}{character vector with ordered (primary is first) names of
different time-to-event variables.}

\item{oceStatus}{character vector with ordered names of status
(0=censored, 1=event) variables.}

\item{group}{name of group variable.}

\item{id}{name of ID variable, NULL creates integer IDs.}

\item{oceNames}{long names of ordered endpoints, NULL uses \code{oceTime}.}

\item{method}{Estimation method, one of 'all', 'npmle', 'coxph' or 'simple'.
Default is 'all' which calculates all of the three methods. See details.}

\item{ciMethod}{confidence interval method, default is 'bootstrap'}

\item{conf.int}{Logical, should confidence intervals be calculated.}

\item{conf.level}{confidence level.}

\item{nBoot}{number of bootstrap replicates (ignored if conf.int=FALSE).}

\item{plot}{logical, plot oce score by group as survival functions
(NPMLE version, except if method='coxph'). For more control over those
plots see either \code{\link{plot.oceNPMLE}} or
\code{\link{plot.oceCoxph}}.}

\item{...}{holder space for future arguments.}
}
\value{
If \code{conf.int=FALSE} then a vector of estimates determined
 by \code{method} results. If \code{conf.int=TRUE} then a matrix is returned
 with a row for each estimate, and 4 columns for the Estimate, lower
 confidence limit, upper confidence limit, and two-sided p-value.
}
\description{
An ordered composite endpoint (oce) is a way of ranking responses by
ordering several types of responses by order of importance. Rank by
the most important response, then break ties with the next most important,
and so on. The tests here are based on two sample tests. Let Y0 and Y1
be the oce score in the control arm and treatment arm, respectively. Then
here we estimate both the win ratio (WR), P[Y1>Y0]/P[Y0>Y1], or the
Mann-Whitney parameter, P[Y1>Y0] + (1/2) Pr[Y1=Y0]. Different methods are
used to estimate those parameters, and inferences are done by bootstrap
percentile methods.
}
\details{
This idea is to stack the time to first event for the k different types of
events. So if TAU is the maximum time that any individual is in the
study, then the primary type of event has scores that fall into (0,TAU],
the secondary type has scores that fall into (TAU,2*TAU], and so on.
Then we rank by the primary type (e.g., death), but if there are many ties
in the primary type (e.g., many that did not die during the study), then
we break ties by the secondary type of event, and so on.

The difficulty is when there is censoring in time, because that imposes
interval censoring on the score scale. This can be handled with interval
censoring methods (although in a non-standard way). The 'npmle' method
calculates a nonparametric maximum likelihood estimate of the 'survival'
distribution of the ordering score for each arm, then gets the estimates
by numeric integration. The 'coxph' method uses an interval censored
proportional hazards model treating the oce scores as time
using \code{\link[survival]{coxph}} from the
survival R package. The 'simple' method uses part of the 'coxph'
method together with a more simple estimator. Each method produces
a win ratio (P[Y1>Y0]/P[Y0>Y1]) and a Mann-Whitney
(P[Y1>Y0] + (1/2) Pr[Y1=Y0]) estimate. Details are given in
Follmann, et al (2020).

When \code{ciMethod="bootstrap"} inferences are done by nonparametric
bootstrap percentile method (see
\code{\link{percci}}) in order to account for the correlation among the
different types of responses. When \code{ciMethod="WLW"} and
\code{method="coxph"}, then the win ratio is calculated by the Cox model
with the standard errors of the log(HR) or log(WR) calculated by the robust
sandwich method suggested by Wei, Lin, and Weissfeld (1989).
P-values are all two-sided and test the
null hypothesis of no difference between the arms (for the win ratio, the
null value is 1, while for the MW the null value is 0).

For access to the \code{coxph} output see \code{\link{oceCoxph}}, or for the
NPMLE output see \code{\link{oceNPMLE}}.
}
\examples{
data(simScenario5)
oceTest(data=simScenario5, oceTime=c("T1","T2","T3"),
 oceStatus=c("I1","I2","I3"), group=c("Z"), id = "PATID",
 oceNames = c("Death","Stroke/MI","Bleed"), method=c("all"))
}
\references{
Follmann, D., Fay, M. P., Hamasaki, T., and Evans, S. (2020). Analysis of
ordered composite endpoints. Statistics in Medicine, 39(5), 602-616.

Wei, L. J., Lin, D. Y., & Weissfeld, L. (1989). Regression analysis of
multivariate incomplete failure time data by modeling marginal distributions.
Journal of the American statistical association, 84(408), 1065-1073.
}
