% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Doptimize.R
\name{Doptimize}
\alias{Doptimize}
\title{Wrapper function for OApackage Doptimize function.}
\usage{
Doptimize(N, k, nrestarts, alpha1 = 1, alpha2 = 0, alpha3 = 0,
  verbose = 1, method = 0, niter = 1e+05, maxtime = 500)
}
\arguments{
\item{N}{Number of runs}

\item{k}{Number of factors}

\item{nrestarts}{Number of restarts to generated an optimal design}

\item{alpha1}{Parameter of the optimization function}

\item{alpha2}{Parameter of the optimization function}

\item{alpha3}{Parameter of the optimization function}

\item{verbose}{Integer that determines the amount of debug output}

\item{method}{Integer, default: 0. The method 0 uses updates of single elements of the design matrix. The method 1 uses swaps of 2 elements of the matrix.}

\item{niter}{Integer (maximum number if iteration steps in the optimization)}

\item{maxtime}{Float (maximum running time before aborting the optimization)}
}
\value{
A matrix containing the generated design
}
\description{
This function generates
a single 2-level design with the specified number of runs and factors. The
design is optimized for the criterium that is specified by the
parameters \eqn{\alpha_i}{alpha_i}.
}
\details{
The criterium that is optimized is:
	\eqn{F = \alpha_1 D + \alpha_2 D_s + \alpha_3  D_1}{F = alpha1*D + alpha2*Ds + alpha3 * D1}

Here D is the D-efficiency of the design and Ds and D1 other efficiency measures.
The values \eqn{\alpha_i}{alpha_i} are scalar parameters.
For more details see http://pietereendebak.nl/oapackage/Doptim.html
}

