% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtrees.R
\name{subtrees}
\alias{subtrees}
\alias{subtrees.rtree}
\alias{subtrees<-}
\title{Subtrees of a tree}
\usage{
subtrees(.tree)

\method{subtrees}{rtree}(.tree)

subtrees(x) <- value
}
\arguments{
\item{.tree, x}{A tree.}

\item{value}{Subtrees to be assigned to \code{x}.}
}
\value{
A (possibly empty) list of trees.
}
\description{
The function \code{subtrees} returns the list of 
subtrees of the root of a given tree.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
(subtrees(tr2))

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Son", "Father", "Grand-Mother"))))
(subtrees(tr3))

}
