% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{timestap_dt_str}
\alias{timestap_dt_str}
\title{Convert unix timestamp to formated date/time string}
\usage{
timestap_dt_str(
  timestamp,
  format = "\%Y-\%m-\%d \%H:\%M:\%S",
  tz = "",
  usetz = FALSE
)
}
\arguments{
\item{timestamp}{int, unix timestamp value}

\item{format}{A character string.  The default for the \code{format}
    methods is
    \code{"\%Y-\%m-\%d \%H:\%M:\%S"} if any element has a time
    component which is not midnight, and \code{"\%Y-\%m-\%d"}
    otherwise.  If \code{\link[base]{options}("digits.secs")} is set, up to
    the specified number of digits will be printed for seconds.}

\item{tz}{A character string specifying the time zone to be used for
    the conversion.  System-specific (see \code{\link[base]{as.POSIXlt}}), but
    \code{""} is the current time zone, and \code{"GMT"} is UTC.
    Invalid values are most commonly treated as UTC, on some platforms with
    a warning.}

\item{usetz}{logical.  Should the time zone abbreviation be appended
    to the output?  This is used in printing times, and more reliable
    than using \code{"\%Z"}.}
}
\value{
The \code{format} methods and \code{strftime} return character vectors
  representing the time.  \code{NA} times are returned as
  \code{NA_character_}.

  \code{strptime} turns character representations into an object of
  class \code{"\link[base]{POSIXlt}"}.  The time zone is used to set the
  \code{isdst} component and to set the \code{"tzone"} attribute if
  \code{tz != ""}.  If the specified time is invalid (for example
  \samp{"2010-02-30 08:00"}) all the components of the result are
  \code{NA}.  (NB: this does means exactly what it says -- if it is an
  invalid time, not just a time that does not exist in some time zone.)
}
\description{
Convert unix timestamp to formated date/time string
}
