% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newTranscript.R
\name{newTranscript}
\alias{newTranscript}
\title{Upload a new transcript.}
\usage{
newTranscript(
  labbcat.url,
  transcript,
  media = NULL,
  transcript.type = NULL,
  corpus = NULL,
  episode = NULL
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcript}{The path to the transcript to upload.}

\item{media}{The path to the media to upload, if any.}

\item{transcript.type}{The transcript type.}

\item{corpus}{The corpus to add the transcript to.}

\item{episode}{The transcript's episode.}
}
\value{
The ID of the new transcript in the corpus
}
\description{
This function adds a transcript and optionally a media file to the corpus.
}
\details{
For this function to work, the credentials used to connect to the server must have at
least 'edit' access.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get attributes for new transcript
corpus <- getCorpusIds(labbcat.url)[1]
transcript.type.layer <- getLayer(labbcat.url, "transcript_type")
transcript.type <- transcript.type.layer$validLabels[[1]]

## upload transcript
newTranscript(
    labbcat.url, "my-transcript.eaf", "my-transcript.wav",
    "", transcript.type, corpus, "episode-1")
}
}
\keyword{management}
\keyword{transcript}
