% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_implications.R
\name{dig_implications}
\alias{dig_implications}
\title{Search for implicative rules}
\usage{
dig_implications(
  x,
  antecedent = everything(),
  consequent = everything(),
  disjoint = NULL,
  min_length = 0L,
  max_length = Inf,
  min_support = 0.02,
  min_confidence = 0.7,
  t_norm = "goguen",
  ...
)
}
\arguments{
\item{x}{a matrix or data frame with data to search in. The matrix must be
numeric (double) or logical. If \code{x} is a data frame then each column
must be either numeric (double) or logical.}

\item{antecedent}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use in the antecedent (left) part of the rules}

\item{consequent}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use in the consequent (right) part of the rules}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the empty
condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of conditions
is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{min_confidence}{the minimum confidence of rules to return. The confidence
of a rule is computed as: supp(antecedent) / supp(antecedent AND consequent).}

\item{t_norm}{a t-norm used to compute conjunction of weights. It must be one of
\code{"goedel"} (minimum t-norm), \code{"goguen"} (product t-norm), or \code{"lukas"}
(Lukasiewicz t-norm).}

\item{...}{Further arguments, currently unused.}
}
\value{
A tibble with found rules.
}
\description{
Search for implicative rules
}
\seealso{
\code{\link[=dig]{dig()}}
}
\author{
Michal Burda
}
