% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgeom.R
\name{Neutrosophic Geometric}
\alias{Neutrosophic Geometric}
\alias{dnsgeom}
\alias{pnsgeom}
\alias{qnsgeom}
\alias{rnsgeom}
\title{Neutrosophic Geometric Distribution}
\usage{
dnsgeom(x, prob)

pnsgeom(q, prob, lower.tail = TRUE)

qnsgeom(p, prob)

rnsgeom(n, prob)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{prob}{probability of success on each trial, \eqn{0 < prob <= 1}.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsgeom} gives the distribution function,
 \code{dnsgeom} gives the density,
 \code{qnsgeom} gives the quantile function and
 \code{rnsgeom} generates random variables from the Geometric Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Geometric distribution with
parameter \code{prob} = \eqn{p_N}.
}
\details{
The neutrosophic Geometric distribution with parameter \eqn{p_N}
has the density
\deqn{f_X(x)=p_N\left(1-p_N\right)^x}
for \eqn{p_N \in (p_L, p_U)} which must be \eqn{0<p_N<1}
and \eqn{x \in \{0, 1, 2, \ldots\}}.
}
\examples{
# One person participates each week with a ticket in a lottery game, where
# the probability of winning the first prize is (10^(-8), 10^(-6)).
# Probability of one persons wins at the fifth year?
dnsgeom(x = 5, prob = c(1e-8, 1e-6))
# Probability of one persons wins after 10 years?
pnsgeom(q = 10, prob = c(1e-8, 1e-6))
pnsgeom(q = 10, prob = c(1e-8, 1e-6), lower.tail = FALSE)
# Calculate the quantiles
qnsgeom(p = c(0.25, 0.5, 0.75), prob = c(1e-8, 1e-6))
# Simulate 10 numbers
rnsgeom(n = 10, prob = c(1e-8, 1e-6))
}
\references{
Granados, C. (2022).
       Some discrete neutrosophic distributions with neutrosophic parameters based on neutrosophic random variables.
        \emph{Hacettepe Journal of Mathematics and Statistics}, 51(5), 1442-1457.
}
