% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsexp.R
\name{Neutrosophic Exponential}
\alias{Neutrosophic Exponential}
\alias{dnsexp}
\alias{pnsexp}
\alias{qnsexp}
\alias{rnsexp}
\title{Neutrosophic Exponential Distribution}
\usage{
dnsexp(x, rate)

pnsexp(q, rate, lower.tail = TRUE)

qnsexp(p, rate)

rnsexp(n, rate)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{rate}{the shape parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsexp} gives the distribution function,
 \code{dnsexp} gives the density,
 \code{qnsexp} gives the quantile function and
 \code{rnsexp} generates random values from the neutrosophic exponential distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic exponential distribution with the
parameter \code{rate} =  \eqn{\theta_N}.
}
\details{
The neutrosophic exponential distribution with parameter \eqn{\theta_N}
has density
\deqn{f_N(x)=\theta_N \exp \left(-x \theta_N\right)}
for \eqn{x \ge 0} and \eqn{\theta_N \in (\theta_L, \theta_U)},
the rate parameter must be a positive interval and \eqn{x \ge 0}.
}
\examples{
# Example 4 of Duan et al. (2021)
data <- matrix(c(4, 4, 3.5, 3.5, 3.9, 4.1, 4.2, 4.2, 4.3, 4.6, 4.7, 4.7),
 nrow = 6, ncol = 2, byrow = TRUE)

dnsexp(data, rate = c(0.23, 0.24))
dnsexp(x = c(4, 4.1), rate = c(0.23, 0.24))

dnsexp(4, rate = c(0.23, 0.23))

# The cumulative distribution function for the nuetrosophic observation (4,4.1)
pnsexp(c(4, 4.1), rate = c(0.23, 0.24), lower.tail = TRUE)

pnsexp(4, rate = c(0.23, 0.24))
# The first percentile
qnsexp(p = 0.1, rate = 0.25)

# The quantiles
qnsexp(p = c(0.25, 0.5, 0.75), rate = c(0.24, 0.25))

# Simulate 10 numbers
rnsexp(n = 10, rate = c(0.23, 0.24))
}
\references{
Duan, W., Q., Khan, Z., Gulistan, M., Khurshid, A. (2021). Neutrosophic
Exponential Distribution: Modeling and Applications for Complex Data Analysis,
\emph{Complexity}, 2021, 1-8.
}
