% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test_ind_response.R
\name{chisq_test_ind_response}
\alias{chisq_test_ind_response}
\title{Test the independence of survey response and auxiliary variables}
\usage{
chisq_test_ind_response(
  survey_design,
  status,
  status_codes = c("ER", "EN", "UE", "IE"),
  aux_vars
)
}
\arguments{
\item{survey_design}{A survey design object created with the \code{survey} package.}

\item{status}{A character string giving the name of the variable representing response/eligibility status.
The \code{status} variable should have at most four categories,
representing eligible respondents (ER), eligible nonrespondents (EN),
known ineligible cases (IE), and cases whose eligibility is unknown (UE).}

\item{status_codes}{A named vector, with four entries named 'ER', 'EN', 'IE', and 'UE'. \cr
\code{status_codes} indicates how the values of the \code{status} variable are to be interpreted.}

\item{aux_vars}{A list of names of auxiliary variables.}
}
\value{
A data frame containing the results of the Chi-Square test(s) of independence between response status and each auxiliary variable.
If multiple auxiliary variables are specified, the output data contains one row per auxiliary variable.
\cr
\cr
The columns of the output dataset include: \cr
\itemize{
\item \code{auxiliary_variable}: The name of the auxiliary variable tested \cr
\item \code{statistic}: The value of the test statistic \cr
\item \code{ndf}: Numerator degrees of freedom for the reference distribution \cr
\item \code{ddf}: Denominator degrees of freedom for the reference distribution \cr
\item \code{p_value}: The p-value of the test of independence \cr
\item \code{test_method}: Text giving the name of the statistical test
\item \code{variance_method}: Text describing the method of variance estimation
}
}
\description{
Tests whether response status among eligible sample cases is independent of categorical auxiliary variables,
using a Chi-Square test with Rao-Scott's second-order adjustment.
If the data include cases known to be ineligible or who have unknown eligibility status,
the data are subsetted to only include respondents and nonrespondents known to be eligible.
}
\details{
Please see \link[survey]{svychisq} for details of how the Rao-Scott second-order adjusted test is conducted.
}
\examples{

# Create a survey design object ----
library(survey)
data(involvement_survey_srs, package = "nrba")

involvement_survey <- svydesign(
  weights = ~BASE_WEIGHT,
  id = ~UNIQUE_ID,
  data = involvement_survey_srs
)


# Test whether response status varies by race or by sex ----

test_results <- chisq_test_ind_response(
  survey_design = involvement_survey,
  status = "RESPONSE_STATUS",
  status_codes = c(
    "ER" = "Respondent",
    "EN" = "Nonrespondent",
    "UE" = "Unknown",
    "IE" = "Ineligible"
  ),
  aux_vars = c("STUDENT_RACE", "STUDENT_SEX")
)

print(test_results)
}
\references{
\itemize{
\item Rao, JNK, Scott, AJ (1984) "On Chi-squared Tests For Multiway Contigency Tables with Proportions Estimated From Survey Data" Annals of Statistics 12:46-60. \cr
}
}
