% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpu.time.R, R/data.grid.R, R/h.cv.R,
%   R/interp.R, R/np.geo.R, R/npsp-internals.R, R/npsp-rules.R, R/splot.R
\name{.cpu.time.ini}
\alias{.cpu.time.ini}
\alias{revdim}
\alias{.compute.masked}
\alias{.wloss}
\alias{residuals.locpol.bin}
\alias{residuals.np.geo}
\alias{npsp-internals}
\alias{print.grid.par}
\alias{dim.grid.par}
\alias{dimnames.grid.par}
\alias{as.data.frame.grid.par}
\alias{is.data.grid}
\alias{dim.data.grid}
\alias{dimnames.data.grid}
\alias{.rice.rule}
\alias{splot.plt}
\alias{.rev.colorRampPalette}
\title{npsp internal and secondary functions}
\usage{
.cpu.time.ini()

revdim(a, d)

.compute.masked(bin, cov.bin = NULL, tol.mask = npsp.tolerance(2))

.wloss(est, teor, w, loss = c("ASE", "ARSE", "AAE", "ARAE"))

\method{residuals}{locpol.bin}(object, ...)

\method{residuals}{np.geo}(object, ...)

\method{print}{grid.par}(x, ...)

\method{dim}{grid.par}(x)

\method{dimnames}{grid.par}(x)

\method{as.data.frame}{grid.par}(x, row.names = dimnames(x),
  optional = FALSE, ...)

is.data.grid(x)

\method{dim}{data.grid}(x)

\method{dimnames}{data.grid}(x)

.rice.rule(x, a = 2, b = 3, ...)

splot.plt(horizontal = FALSE, legend.shrink = 0.9, legend.width = 1,
  legend.mar = ifelse(horizontal, 3.1, 5.1), bigplot = NULL,
  smallplot = NULL)

.rev.colorRampPalette(colors, interpolate = "spline", ...)
}
\arguments{
\item{a}{scale values.}

\item{cov.bin}{(optional) covariance matrix of the binned data or semivariogram model
(\code{\link{svarmod}}-class) of the (unbinned) data.}

\item{b}{exponent values.}
}
\value{
\code{.compute.masked} returns a list with components:
\item{mask}{logical vector \code{bin$binw > tol.mask}.}
\item{w}{\code{x$binw[mask]}.}
\item{sw}{\code{sum(w)}.}
\item{hat}{(optional) \code{bin$locpol$hat[mask, mask]}.}
\item{cov.bin}{(optional) masked (aproximated) covariance matrix of the binned data.}
}
\description{
Listed below are supporting functions for the major methods in npsp.
}
\keyword{internal}
