% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/np.geo.R
\name{np.fitgeo}
\alias{np.fitgeo}
\alias{np.fitgeo.default}
\alias{np.fitgeo.locpol.bin}
\alias{np.fitgeo.fitgeo}
\title{Fit a nonparametric geostatistical model}
\usage{
np.fitgeo(x, ...)

\method{np.fitgeo}{default}(
  x,
  y,
  nbin = NULL,
  iter = 2,
  h = NULL,
  tol = 0.05,
  set.NA = FALSE,
  h.svar = NULL,
  corr.svar = iter > 0,
  maxlag = NULL,
  nlags = NULL,
  dk = 0,
  svm.resid = FALSE,
  hat.bin = corr.svar,
  warn = FALSE,
  plot = FALSE,
  window = NULL,
  ...
)

\method{np.fitgeo}{locpol.bin}(
  x,
  svm,
  iter = 1,
  tol = 0.05,
  h.svar = svm$esv$locpol$h,
  dk = 0,
  corr.svar = TRUE,
  svm.resid = FALSE,
  hat.bin = corr.svar,
  warn = FALSE,
  plot = FALSE,
  ...
)

\method{np.fitgeo}{fitgeo}(
  x,
  iter = 1,
  tol = 0.05,
  h.svar = x$svm$esv$locpol$h,
  dk = x$svm$par$dk,
  corr.svar = TRUE,
  svm.resid = FALSE,
  hat.bin = corr.svar,
  warn = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{a (data) object used to select a method.}

\item{...}{further arguments passed to \code{\link{h.cv}}
(trend bandwith selection parameters).}

\item{y}{vector of data (response variable).}

\item{nbin}{vector with the number of bins on each dimension.}

\item{iter}{maximum number of interations (of the whole algorithm).}

\item{h}{initial bandwidth matrix for trend estimation
(final bandwith if \code{iter = 1}).}

\item{tol}{relative convergence tolerance (semivariogram).}

\item{set.NA}{logical. If \code{TRUE}, sets the bin averages corresponding
to cells without data to \code{NA}.}

\item{h.svar}{bandwidth matrix for variogram estimation.}

\item{corr.svar}{logical; if \code{TRUE} (default), a bias-corrected semivariogram estimate 
is computed (see \code{\link{np.svariso.corr}}). 
If \code{FALSE} the (uncorrected) residual variogram is computed
(the traditional approach in geostatistics).}

\item{maxlag}{maximum lag. Defaults to 55\% of largest lag.}

\item{nlags}{number of lags. Defaults to 101.}

\item{dk}{dimension of the Shapiro-Botha variogram model (see \code{\link{fitsvar.sb.iso}}).}

\item{svm.resid}{logical; if \code{TRUE}, the fitted (uncorrected) residual semivariogram model
is computed and returned (this parameter has no effect when \code{corr.svar = FALSE}).}

\item{hat.bin}{logical; if \code{TRUE}, the hat matrix of the binned data is returned.}

\item{warn}{logical; sets the handling of warning messages in bandwith selection (\code{\link{h.cv}}).}

\item{plot}{logical; if \code{TRUE}, semivariogram estimates obtained at each iteration are plotted.}

\item{window}{spatial window (values outside this window will be masked), currently an sp-object of class 
extending \code{\link[sp:SpatialPolygons-class]{SpatialPolygons}}.}

\item{svm}{(fitted) variogram model (object of class 
\code{\link{fitsvar}} or \code{\link{svarmod}}).}
}
\value{
Returns an object of \code{\link{class}} \code{fitgeo} 
(extends \code{\link{np.geo}}). A \code{\link{locpol.bin}} object
with the additional (some optional) 3 components:
\item{svm}{fitted variogram model (object of class 
 \code{\link{fitsvar}}).}
\item{svm0}{(if requested) fitted residual variogram model (object of class 
 \code{\link{fitsvar}}).}
\item{residuals}{model residuals.}
}
\description{
Fits a nonparametric (isotropic) geostatistical model 
(jointly estimates the trend and the variogram) by calling 
\code{\link{locpol}},  \code{\link{np.svariso.corr}} (or \code{\link{np.svariso}} ) and 
\code{\link{fitsvar.sb.iso}} iteratively. 
At each iteration, the trend estimation bandwith is updated 
by a call to \code{\link{h.cv}}.
}
\details{
Currently, only isotropic semivariogram estimation is supported.

If parameter \code{h} is not specified,
\code{\link{h.cv}} is called with the default values (modified CV) to set it.
If parameter \code{h.svar} is not specified,
is set to \code{1.5*h.cv.svar.bin()$h}.

Setting \code{corr.svar = TRUE} may be very slow (and memory demanding) when the number of data is large 
(note also that the bias in the residual variogram decreases when the sample size increases).
}
\examples{

geomod <- np.fitgeo(aquifer[,1:2], aquifer$head, svm.resid = TRUE)
plot(geomod)


# Uncorrected variogram estimator
geomod0 <- np.fitgeo(aquifer[,1:2], aquifer$head, iter = 0, corr.svar = FALSE)
plot(geomod0)

# Additional iteration with bias-corrected variogram estimator
geomod1 <- np.fitgeo(geomod0, corr.svar = TRUE, svm.resid = TRUE)
plot(geomod1)

}
\seealso{
\code{\link{locpol}}, \code{\link{fitsvar.sb.iso}}, \code{\link{np.svar}}, 
\code{\link{np.svariso.corr}}, \code{\link{np.geo}}.
}
