% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allotest.R
\name{allotest}
\alias{allotest}
\title{Bootstrap based test for testing an allometric model}
\usage{
allotest(formula, data = data, na.action = "na.omit", nboot = 500,
  kbin = 200, seed = NULL)
}
\arguments{
\item{formula}{An object of class \code{formula}: a sympbolic description
of the model to be fitted.}

\item{data}{A data frame argumment or matrix containing the model response variable
and covariates required by the \code{formula}.}

\item{na.action}{A function which indicates what should happen when the 
data contain 'NA's. The default is 'na.omit'.}

\item{nboot}{Number of bootstrap repeats.}

\item{kbin}{Number of binning nodes over which the function
is to be estimated.}

\item{seed}{Seed to be used in the bootstrap procedure.}
}
\value{
An object is returned with the following elements:
\item{statistic}{the value of the test statistic.}
\item{value}{the p-value of the test.}
}
\description{
Bootstrap-based procedure that tests whether the data 
can be modelled by an allometric model.
}
\details{
In order to facilitate the choice of a model appropriate
to the data while at the same time endeavouring to minimise the 
loss of information,  a bootstrap-based procedure, that test whether the 
data can be modelled by an allometric model, was developed.  Therefore,
\code{allotest} tests the null hypothesis of an allometric model taking 
into account the logarithm of the original variable
 (\eqn{X^* = log(X)} and \eqn{Y^* = log(Y)}). 
 
Based on a general model of the type 
\deqn{Y^*=m(X^*)+\varepsilon}
the aim here is to test the null hypothesis of an allometric model 
\deqn{H_0 = m(x^*) =  a^*+ b^* x^*}
\eqn{vs.} the general hypothesis 
\eqn{H_1}, with \eqn{m}
being an unknown nonparametric function; or analogously,
\deqn{H_1: m(x^*)= a^*+ b^* x^* + g(x^*)}
with \eqn{g(x^*)} being an unknown function not equal to zero. 

To implement this test we have used the wild bootstrap.
}
\examples{
library(npregfast)
data(barnacle)
allotest(DW ~ RC, data = barnacle, nboot = 50, seed = 130853)

}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\references{
Sestelo, M. and Roca-Pardinas, J. (2011). A new approach to estimation of 
length-weight relationship of \eqn{Pollicipes}  \eqn{pollicipes} (Gmelin, 1789)
on the Atlantic coast of Galicia (Northwest Spain): some aspects of its 
biology and management. Journal of Shellfish Research, 30 (3), 939--948.

Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.
}

