% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-scatterplot.R
\name{npde.plot.scatterplot}
\alias{npde.plot.scatterplot}
\alias{compute.bands.true}
\alias{compute.bands}
\alias{aux.npdeplot.computepi}
\alias{aux.npdeplot.meanprof}
\alias{aux.npdeplot.pimat}
\alias{aux.npdeplot.transformPI}
\alias{aux.npdeplot.transformObs}
\title{Scatterplots and VPC}
\usage{
npde.plot.scatterplot(npdeObject, which.x="x", which.y="npd", ref.prof=NULL, ...)
}
\arguments{
\item{npdeObject}{an object returned by a call to \code{\link{npde}} or \code{\link{autonpde}}}

\item{which.x}{a string specifying the variable on the X-axis (one of "x", "pred", "cov")}

\item{which.y}{a string specifying the variable on the Y-axis (one of "yobs", "npde", "pd", "npd"), defaults to "npd"}

\item{ref.prof}{either a character string (one of "covariate" or "all"), or a named list specifying the characteristics of the reference profile (see details)}

\item{\dots}{additional arguments to be passed on to the function, to control which metric (npde, pd, npd) is used or to override graphical parameters (see the PDF document for details, as well as \code{\link{set.plotoptions}} and \code{\link{npdeControl}})}
}
\value{
a ggplot object or a list of ggplot objects (grobs)
}
\description{
Produces a scatterplot. Different types of scatterplots can be produced, with associated prediction bands (see details).
}
\details{
VPC: obtained using which.x="x", which.y="yobs"

Scatterplots of npde/pd/npd can be obtained versus "x" (independent variable) or "pred" (population predictions from the model)

Scatterplots of npde/pd/npd/observations can be obtained versus covariates by setting the which.x argument to "cov" and selecting the appropriate which.y. The function will use the covariates in the which.cov element of the prefs slot. This can be overriden to cycle over all the covariates in the dataset by supplying the argument which.cov="all" in the call to the function.

Reference profile: a reference profile can be added to scatterplots of npd and npde versus the independent variable (see Comets et al. 2013)

If ref.prof="all" (and covsplit is FALSE), the reference plot will be computed over all subjects using the mean and SD of all simulated data in each bin (see documentation).

If ref.prof="covariate" and an additional argument covsplit is given (covsplit=TRUE), the reference plot will be adjusted for each covariate category over all the covariates in the which.cov element of the prefs slot (see  \code{\link{npdeControl}} for details on the prefs slot of the npdeObject).

If ref.prof is given as a named list (eg list(ID=c(1,5)) or list(sex=0, dose=c(50,100)), where names should refer to columns in the data file (eg ID should be a column in the data)), the reference profile will be obtained by combining (in the first example above, the reference profile will be obtained using the simulated data for subjects 1 and 5, while in the second example it will be computed using the subjects with sex=0 given doses 50 or 100).
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.  Mentre.
Metrics for external model evaluation with an application to the population pharmacokinetics of gliclazide.
\emph{Pharmaceutical Research}, 23:2036--49, 2006.

E. Comets, T.H.T. Nguyen, and F. Mentré F. Additional features and graphs in the new npde library for R.
\emph{22th meeting of the Population Approach Group in Europe}, Glasgow, United Kingdom, 2013.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}, \code{\link{set.plotoptions}}, \code{\link{npdeControl}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{plot}
