% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{nomis_get_metadata}
\alias{nomis_get_metadata}
\title{Nomis metadata concepts and types}
\usage{
nomis_get_metadata(id, concept = NULL, type = NULL, search = NULL,
  additional_queries = NULL, ...)
}
\arguments{
\item{id}{The ID of the particular dataset. Returns no data if not specified.}

\item{concept}{A string with the variable concept to return options for. If
left empty, returns all the variables for the dataset specified by \code{id}.
Codes are not case sensitive. Defaults to \code{NULL}.}

\item{type}{A string with options for a particular code value, to return
types of variables available for a given code. Defaults to \code{NULL}. If
\code{concept == NULL}, \code{type} will be ignored.}

\item{search}{A string or character vector of strings to search for in the
metadata. Defaults to \code{NULL}. As in \code{\link{nomis_search}}, the
wildcard character \code{*} can be added to the beginning and/or end of each
search string.}

\item{additional_queries}{Any other additional queries to pass to the API.
See \url{https://www.nomisweb.co.uk/api/v01/help} for instructions on
query structure. Defaults to \code{NULL}. Deprecated in package 
versions greater than 0.2.0 and will eventually be removed.}

\item{...}{Use to pass any other parameters to the API.}
}
\value{
A tibble with metadata options for queries using 
\code{\link{nomis_get_data}}.
}
\description{
Retrieve all concept code options of all Nomis datasets, 
concept code options for a given dataset, or the all the options for a given
concept variable from a particular dataset. Specifying \code{concept} will
return all the options for a given variable in a particular dataset.

If looking for a more detailed overview of all available
metadata for a given dataset, see \code{\link{nomis_overview}}.
}
\examples{
\donttest{
a <- nomis_get_metadata('NM_1_1')

tibble::glimpse(a)

b <- nomis_get_metadata('NM_1_1', 'geography')

tibble::glimpse(b)

# returns all types of geography
c <- nomis_get_metadata('NM_1_1', 'geography', 'TYPE')

tibble::glimpse(c)

# returns geography types available within Wigan
d <- nomis_get_metadata('NM_1_1', 'geography', '1879048226')

tibble::glimpse(d)

e <- nomis_get_metadata('NM_1_1', 'item', geography = 1879048226, sex = 5)

print(e)

f <- nomis_get_metadata('NM_1_1', 'item', search = "*married*")

tibble::glimpse(f)
}
}
\seealso{
\code{\link{nomis_data_info}}

\code{\link{nomis_get_data}}

\code{\link{nomis_overview}}
}
