% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo_lite.R
\name{reverse_geo_lite}
\alias{reverse_geo_lite}
\title{Reverse geocode coordinates}
\usage{
reverse_geo_lite(
  lat,
  long,
  address = "address",
  full_results = FALSE,
  return_coords = TRUE,
  verbose = FALSE,
  custom_query = list()
)
}
\arguments{
\item{lat}{latitude values (input data)}

\item{long}{longitude values (input data)}

\item{address}{name of the address column (in the output data)}

\item{full_results}{returns all data from the geocoder service if TRUE.
If FALSE then only a single address column will be returned from the geocoder service.}

\item{return_coords}{return input coordinates with results if TRUE. Note that
most services return the input coordinates with \code{full_results = TRUE} and setting
\code{return_coords} to FALSE does not prevent this.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (ie. \code{list(zoom = 3)}). See Details.}
}
\value{
A \code{tibble} with the results.
}
\description{
Reverse geocodes geographic coordinates (latitude and longitude) given as
numeric values. Latitudes must be between -90 and 90 and longitudes must be
between -180 and 180.
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Reverse/} for additional
parameters to be passed to \code{custom_query}.

Use the option \code{custom_query = list(zoom = 3)} to adjust the output. Some
equivalences on terms of zoom:\tabular{rl}{
   zoom \tab address_detail \cr
   3 \tab country \cr
   5 \tab state \cr
   8 \tab county \cr
   10 \tab city \cr
   14 \tab suburb \cr
   16 \tab major streets \cr
   17 \tab major and minor streets \cr
   18 \tab building \cr
}
}
\examples{
\donttest{

reverse_geo_lite(lat = 40.75728, long = -73.98586)

# Several coordinates
reverse_geo_lite(
  lat = c(40.75728, 55.95335),
  long = c(-73.98586, -3.188375)
)

# With options: zoom to country
reverse_geo_lite(
  lat = c(40.75728, 55.95335),
  long = c(-73.98586, -3.188375),
  custom_query = list(zoom = 0),
  verbose = TRUE,
  full_results = TRUE
)
}
}
\seealso{
\code{\link[=reverse_geo_lite_sf]{reverse_geo_lite_sf()}}, \code{\link[tidygeocoder:reverse_geo]{tidygeocoder::reverse_geo()}}

Other geocoding: 
\code{\link{geo_address_lookup}()},
\code{\link{geo_lite}()}
}
\concept{geocoding}
